/*
     kalc: A Scientific RPN Calculator
     Copyright (C) 1999-2000 Eduardo M Kalinowski (ekalin@iname.com)

     This program is free software. You may redistribute it, but only in
     its whole, unmodified form. You are allowed to make changes to this
     program, but you must not redistribute the changed version.

     This program is distributed in the hope it will be useful, but there
     is no warranty.

     For details, see the COPYING file.
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

#include "cmp.h"
#include "kalc.h"


void f_dtag(void) 
{
  /*
   * This is the function run by the user command dtag. It checks
   * for the presence of one argument then calls the dtag() function,
   * that strips all the tags of an object.
   */

  if (enoughArgs(1))
    dtag(tos);
  else
    doError("dtag", ERR_TOOFEWARGUMENTS);
}


void f_TOtag(void) 
{
  /*
   * This is the function run by the user command >tag. It attaches
   * a tag to an object.
   * If the tag is not a string, it is converted to a string. Identifiers
   * are converted without the quotes.
   */

  if (enoughArgs(2)) {
    Object *taggedObj = (Object *) malloc(sizeof(Object));

    if (type(**tos) == TYPE_ID)
      f_idTOstr();
    else if (type(**tos) != TYPE_STR)
      f_TOstr();

    taggedObj->type = TYPE_TAGGED;
    taggedObj->value.tagged.tag = strdup((**tos).value.str);
    taggedObj->value.tagged.obj = *(tos - 1);
    *(tos - 1) = taggedObj;
    _f_drop();
  } else
    doError(">tag", ERR_TOOFEWARGUMENTS);
}



void dtag(Object **n) 
{
  /*
   * This function removes all the tags of the object given.
   */
  Object *o;

  while (type(**n) == TYPE_TAGGED) {
    o = (**n).value.tagged.obj;
    free ((**n).value.tagged.tag);
    free (*n);
    *n = o;
  }
}
