/*
     kalc: A Scientific RPN Calculator
     Copyright (C) 1999-2000 Eduardo M Kalinowski (ekalin@iname.com)

     This program is free software. You may redistribute it, but only in
     its whole, unmodified form. You are allowed to make changes to this
     program, but you must not redistribute the changed version.

     This program is distributed in the hope it will be useful, but there
     is no warranty.

     For details, see the COPYING file.
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <setjmp.h>

#include "cmp.h"
#include "kalc.h"


void f_eq(void)
{
  /*
   * This function calls the _f_eq function through the wrapper.
   */

  run2_1_Function(_f_eq, "==");
}


void f_neq(void)
{
  /*
   * This function calls the _f_neq function through the wrapper.
   */

  run2_1_Function(_f_neq, "!=");
}


void f_lt(void)
{
  /*
   * This function calls the _f_lt function through the wrapper.
   */

  run2_1_Function(_f_lt, "<");
}


void f_gt(void)
{
  /*
   * This function calls the _f_gt function through the wrapper.
   */

  run2_1_Function(_f_gt, ">");
}


void f_lte(void)
{
  /*
   * This function calls the _f_lte function through the wrapper.
   */

  run2_1_Function(_f_lte, "<=");
}


void f_gte(void)
{
  /*
   * This function calls the _f_gte function through the wrapper.
   */

  run2_1_Function(_f_gte, ">=");
}


Object _f_eq(Object n, Object p, int *err)
{
  /*
   * This function returns 1 if the objects are equal, 0 if not.
   */
  
  Object result;
  result.type = TYPE_REAL;

  *err = ERR_NOERR;

  if (type(n) != type(p))
    result.value.real = 0;
  else
    switch (type(n)) {
    case TYPE_REAL:
      result.value.real = (n.value.real == p.value.real);
      break;

    case TYPE_CMP:
      result.value.real = ((n.value.cmp.re == p.value.cmp.re)
			   && (n.value.cmp.im == p.value.cmp.im));
      break;

    case TYPE_STR:
      result.value.real = !strcmp(n.value.str, p.value.str);
      break;

    default:
      *err = ERR_BADARGUMENTTYPE;
      break;
    }

  return result;
}


Object _f_neq(Object n, Object p, int *err)
{
  /*
   * This function returns 1 if the objects are not equal, 0 if they are.
   */
  
  Object result;
  result.type = TYPE_REAL;

  *err = ERR_NOERR;

  if (type(n) != type(p))
    result.value.real = 1;
  else
    switch (type(n)) {
    case TYPE_REAL:
      result.value.real = (n.value.real != p.value.real);
      break;

    case TYPE_CMP:
      result.value.real = ((n.value.cmp.re != p.value.cmp.re)
			   || (n.value.cmp.im != p.value.cmp.im));
      break;

    case TYPE_STR:
      result.value.real = strcmp(n.value.str, p.value.str) != 0;
      break;

    default:
      *err = ERR_BADARGUMENTTYPE;
      break;
    }

  return result;
}


Object _f_lt(Object n, Object p, int *err)
{
  /*
   * This function returns 1 if n is less than p, or 0 if not.
   * For strings, the comparation is using standard ASCII order.
   */
  
  Object result;
  result.type = TYPE_REAL;

  switch (type(n)) {
  case TYPE_REAL:
    switch (type(p)) {
    case TYPE_REAL:
      *err = ERR_NOERR;
      result.value.real = n.value.real < p.value.real;
      break;
    default:
      *err = ERR_BADARGUMENTTYPE;
      break;
    }
    break;

  case TYPE_STR:
    switch (type(p)) {
    case TYPE_STR:
      *err = ERR_NOERR;
      result.value.real = strcmp(n.value.str, p.value.str) < 0;
      break;
    default:
      *err = ERR_BADARGUMENTTYPE;
      break;
    }
    break;
      
  default:
    *err = ERR_BADARGUMENTTYPE;
    break;
  }

  return result;
}


Object _f_gt(Object n, Object p, int *err)
{
  /*
   * This function returns 1 if n is greater than p, or 0 if not.
   * For strings, the comparation is using standard ASCII order.
   */
  
  Object result;
  result.type = TYPE_REAL;

  switch (type(n)) {
  case TYPE_REAL:
    switch (type(p)) {
    case TYPE_REAL:
      *err = ERR_NOERR;
      result.value.real = n.value.real > p.value.real;
      break;
    default:
      *err = ERR_BADARGUMENTTYPE;
      break;
    }
    break;

  case TYPE_STR:
    switch (type(p)) {
    case TYPE_STR:
      *err = ERR_NOERR;
      result.value.real = strcmp(n.value.str, p.value.str) > 0;
      break;
    default:
      *err = ERR_BADARGUMENTTYPE;
      break;
    }
    break;
      
  default:
    *err = ERR_BADARGUMENTTYPE;
    break;
  }

  return result;
}


Object _f_lte(Object n, Object p, int *err)
{
  /*
   * This function returns 1 if n is less than or equal to p, or 0
   * if not.
   * For strings, the comparation is using standard ASCII order.
   */
  
  Object result;
  result.type = TYPE_REAL;

  switch (type(n)) {
  case TYPE_REAL:
    switch (type(p)) {
    case TYPE_REAL:
      *err = ERR_NOERR;
      result.value.real = n.value.real <= p.value.real;
      break;
    default:
      *err = ERR_BADARGUMENTTYPE;
      break;
    }
    break;

  case TYPE_STR:
    switch (type(p)) {
    case TYPE_STR:
      *err = ERR_NOERR;
      result.value.real = strcmp(n.value.str, p.value.str) <= 0;
      break;
    default:
      *err = ERR_BADARGUMENTTYPE;
      break;
    }
    break;
      
  default:
    *err = ERR_BADARGUMENTTYPE;
    break;
  }

  return result;
}


Object _f_gte(Object n, Object p, int *err)
{
  /*
   * This function returns 1 if n is greater than or equal to p,
   * or 0 if not.
   * For strings, the comparation is using standard ASCII order.
   */
  
  Object result;
  result.type = TYPE_REAL;

  switch (type(n)) {
  case TYPE_REAL:
    switch (type(p)) {
    case TYPE_REAL:
      *err = ERR_NOERR;
      result.value.real = n.value.real >= p.value.real;
      break;
    default:
      *err = ERR_BADARGUMENTTYPE;
      break;
    }
    break;

  case TYPE_STR:
    switch (type(p)) {
    case TYPE_STR:
      *err = ERR_NOERR;
      result.value.real = strcmp(n.value.str, p.value.str) >= 0;
      break;
    default:
      *err = ERR_BADARGUMENTTYPE;
      break;
    }
    break;
      
  default:
    *err = ERR_BADARGUMENTTYPE;
    break;
  }

  return result;
}
