/*
 * This demo shows the use of a positioner with XOR drawmode, most
 * useful for overlaying positioner on top of other object
 *
 *  This file is part of xforms package
 *  T.C. Zhao and M. Overmars  1997
 */

#include <stdio.h>
#include "forms.h"
#include <math.h>
#include <stdlib.h>

FL_OBJECT *xval, *yval, *pos;

/* callback routine */
void
positioner_cb(FL_OBJECT *ob, long q)
{
    char str[30];
    sprintf(str,"%f",fl_get_positioner_xvalue(ob));
    fl_set_input(xval,str);
    sprintf(str,"%f",fl_get_positioner_yvalue(ob));
    fl_set_input(yval,str);
}

static void val_cb(FL_OBJECT *ob, long val)
{
   float xpos, ypos;

   if(val)
   {
     xpos = atof(fl_get_input(ob)); 
     fprintf(stderr,"x=%f\n",xpos);
     fl_set_positioner_xvalue(pos,xpos);
   }
   else
   {
     ypos = atof(fl_get_input(ob)); 
     fprintf(stderr,"y=%f\n",ypos);
     fl_set_positioner_yvalue(pos,ypos);
   }
}

int
main(int argc, char *argv[])
{
  FL_FORM *form;
  FL_OBJECT  *button, *ob;

  fl_set_border_width(-2);
  fl_initialize(&argc, argv, "FormDemo", 0, 0);

  form = fl_bgn_form(FL_UP_BOX,350,250);

     ob = fl_add_pixmap(FL_NORMAL_PIXMAP, 60, 70, 100, 100, "");
     fl_set_object_boxtype(ob, FL_DOWN_BOX);
     fl_set_pixmap_file(ob, "porsche.xpm");

     pos = fl_add_positioner(FL_OVERLAY_POSITIONER,60,70,100,100,"");

     fl_set_positioner_xbounds(pos,0,1);
     fl_set_positioner_ybounds(pos,0,1);
     fl_set_object_callback(pos,positioner_cb,0);
     xval = fl_add_input(FL_FLOAT_INPUT,230,40,100,30,"");
     fl_set_object_callback(xval, val_cb,1);
     yval = fl_add_input(FL_FLOAT_INPUT,230,90,100,30,"");
     fl_set_object_callback(yval, val_cb,0);
     fl_set_object_color(xval,FL_COL1,FL_COL1);
     fl_set_object_color(yval,FL_COL1,FL_COL1);
     button = fl_add_flatbutton(FL_PUSH_BUTTON,230,200,100,30,"Exit");
     fl_set_object_color(button,FL_RED, FL_BLUE);
  fl_end_form();

  fl_show_form(form,FL_PLACE_CENTER,FL_TRANSIENT,"XOR Positioner");

  positioner_cb(pos,0);
  while (fl_do_forms());
  fl_hide_form(form);

  return 0;
}
