/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jdbc.appender;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.jdbc.appender.DriverManagerConnectionSource;
import org.junit.Assert;
import org.junit.Test;

public class DriverManagerH2ConnectionSourceTest {
    @Test
    public void testH2Properties() throws SQLException {
        Property[] properties = new Property[]{Property.createProperty((String)"username", (String)"sa"), Property.createProperty((String)"password", (String)"")};
        DriverManagerConnectionSource source = ((DriverManagerConnectionSource.Builder)((DriverManagerConnectionSource.Builder)DriverManagerConnectionSource.newBuilder().setConnectionString("jdbc:h2:mem:Log4j")).setProperties(properties)).build();
        try (Connection conn = source.getConnection();){
            Assert.assertFalse((boolean)conn.isClosed());
        }
    }

    @Test
    public void testH2UserAndPassword() throws SQLException {
        DriverManagerConnectionSource source = ((DriverManagerConnectionSource.Builder)((DriverManagerConnectionSource.Builder)((DriverManagerConnectionSource.Builder)DriverManagerConnectionSource.newBuilder().setConnectionString("jdbc:h2:mem:Log4j")).setUserName("sa".toCharArray())).setPassword("".toCharArray())).build();
        try (Connection conn = source.getConnection();){
            Assert.assertFalse((boolean)conn.isClosed());
        }
    }
}

