/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.internal.util;

import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.internal.util.BindingMap;
import org.apache.logging.log4j.plugins.internal.util.HierarchicalMap;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.InternalApi;
import org.jspecify.annotations.Nullable;

@InternalApi
public final class DefaultBindingMap
implements BindingMap {
    private final HierarchicalMap<Key<?>, Supplier<?>> bindings;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    DefaultBindingMap(HierarchicalMap<Key<?>, Supplier<?>> bindings) {
        this.bindings = bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> @Nullable Supplier<T> get(Key<T> key, Iterable<String> aliases) {
        this.lock.readLock().lock();
        try {
            Supplier<T> existing = this.get(key);
            if (existing != null) {
                Supplier<T> supplier = existing;
                return supplier;
            }
            for (String alias : aliases) {
                Supplier<T> existingAlias = this.get(key.withName(alias));
                if (existingAlias == null) continue;
                Supplier<T> supplier = existingAlias;
                return supplier;
            }
            Iterator<String> iterator = null;
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private <T> @Nullable Supplier<T> get(Key<T> key) {
        return (Supplier)Cast.cast(this.bindings.get(key));
    }

    @Override
    public <T> void put(Key<? super T> key, Supplier<T> factory) {
        this.lock.writeLock().lock();
        try {
            this.bindings.put(key, factory);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public <T> void putIfAbsent(Key<? super T> key, Supplier<T> factory) {
        this.lock.writeLock().lock();
        try {
            this.bindings.putIfAbsent(key, factory);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void remove(Key<?> key) {
        this.lock.writeLock().lock();
        try {
            this.bindings.remove(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean containsKey(Key<?> key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.bindings.containsKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean containsLocalKey(Key<?> key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.bindings.containsLocalKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public BindingMap newChildMap() {
        return new DefaultBindingMap(this.bindings.newChildMap());
    }
}

