/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.async.logger.internal;

import com.lmax.disruptor.WaitStrategy;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.async.logger.AsyncLoggerConfigDisruptor;
import org.apache.logging.log4j.async.logger.AsyncLoggerDisruptor;
import org.apache.logging.log4j.async.logger.AsyncLoggerProperties;
import org.apache.logging.log4j.async.logger.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.async.logger.DisruptorConfiguration;
import org.apache.logging.log4j.async.logger.internal.DefaultAsyncWaitStrategyFactory;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.plugins.Factory;
import org.apache.logging.log4j.plugins.Named;
import org.apache.logging.log4j.plugins.SingletonFactory;
import org.apache.logging.log4j.plugins.condition.ConditionalOnMissingBinding;
import org.apache.logging.log4j.plugins.condition.ConditionalOnPresentBindings;

public final class AsyncLoggerDefaultBundle {
    @Factory
    @Named(value={"AsyncLogger"})
    @ConditionalOnMissingBinding
    public @Named(value={"AsyncLogger"}) WaitStrategy asyncLoggerWaitStrategy(PropertyEnvironment environment, @Named(value={"StatusLogger"}) @Named(value={"StatusLogger"}) Logger statusLogger) {
        statusLogger.debug("No AsyncWaitStrategyFactory was configured in the configuration, using default factory...");
        return new DefaultAsyncWaitStrategyFactory(((AsyncLoggerProperties)environment.getProperty(AsyncLoggerProperties.class)).waitStrategy()).createWaitStrategy();
    }

    @SingletonFactory
    @ConditionalOnMissingBinding
    public AsyncLoggerDisruptor.Factory asyncLoggerDisruptorFactory(AsyncQueueFullPolicy asyncQueueFullPolicy, @Named(value={"AsyncLogger"}) @Named(value={"AsyncLogger"}) WaitStrategy waitStrategy, PropertyEnvironment environment) {
        return contextName -> new AsyncLoggerDisruptor(contextName, asyncQueueFullPolicy, waitStrategy, (AsyncLoggerProperties)environment.getProperty(AsyncLoggerProperties.class));
    }

    @Factory
    @Named(value={"AsyncLoggerConfig"})
    @ConditionalOnPresentBindings(bindings={Configuration.class})
    public @Named(value={"AsyncLoggerConfig"}) WaitStrategy defaultAsyncLoggerWaitStrategy(Configuration configuration, PropertyEnvironment environment, @Named(value={"StatusLogger"}) @Named(value={"StatusLogger"}) Logger statusLogger) {
        AsyncWaitStrategyFactory factory;
        DisruptorConfiguration disruptorConfiguration = (DisruptorConfiguration)configuration.getExtension(DisruptorConfiguration.class);
        if (disruptorConfiguration != null && (factory = disruptorConfiguration.getWaitStrategyFactory()) != null) {
            statusLogger.debug("Using configured AsyncWaitStrategyFactory {}", (Object)factory.getClass().getName());
            return factory.createWaitStrategy();
        }
        return this.asyncLoggerWaitStrategy(environment, statusLogger);
    }

    @Factory
    @ConditionalOnPresentBindings(bindings={Configuration.class})
    public AsyncLoggerConfigDisruptor asyncLoggerConfigDisruptor(AsyncQueueFullPolicy asyncQueueFullPolicy, @Named(value={"AsyncLoggerConfig"}) @Named(value={"AsyncLoggerConfig"}) WaitStrategy waitStrategy, LogEventFactory logEventFactory, PropertyEnvironment environment) {
        return new AsyncLoggerConfigDisruptor(asyncQueueFullPolicy, waitStrategy, logEventFactory, (AsyncLoggerProperties)environment.getProperty(AsyncLoggerProperties.class));
    }
}

