/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.controller;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.api.Attribute;
import org.apache.logging.log4j.catalog.api.CatalogData;
import org.apache.logging.log4j.catalog.api.Category;
import org.apache.logging.log4j.catalog.api.Event;
import org.apache.logging.log4j.catalog.api.Product;
import org.apache.logging.log4j.catalog.api.dao.CatalogDao;
import org.apache.logging.log4j.catalog.jpa.converter.AttributeModelConverter;
import org.apache.logging.log4j.catalog.jpa.converter.CategoryModelConverter;
import org.apache.logging.log4j.catalog.jpa.converter.EventModelConverter;
import org.apache.logging.log4j.catalog.jpa.converter.ProductModelConverter;
import org.apache.logging.log4j.catalog.jpa.model.AttributeModel;
import org.apache.logging.log4j.catalog.jpa.model.CategoryModel;
import org.apache.logging.log4j.catalog.jpa.model.EventModel;
import org.apache.logging.log4j.catalog.jpa.model.ProductModel;
import org.apache.logging.log4j.catalog.jpa.service.AttributeService;
import org.apache.logging.log4j.catalog.jpa.service.CategoryService;
import org.apache.logging.log4j.catalog.jpa.service.EventService;
import org.apache.logging.log4j.catalog.jpa.service.ProductService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CatalogController {
    private static Logger logger = LogManager.getLogger(CatalogController.class);
    @Autowired
    private EventService eventService;
    @Autowired
    private AttributeService attributeService;
    @Autowired
    private ProductService productService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private AttributeModelConverter attributeModelConverter;
    @Autowired
    private EventModelConverter eventModelConverter;
    @Autowired
    private ProductModelConverter productModelConverter;
    @Autowired
    private CategoryModelConverter categoryModelConverter;
    @Autowired
    private CatalogDao catalogDao;

    @PostMapping(value={"catalog"})
    public ResponseEntity<?> saveCatalog() {
        CatalogData catalogData = new CatalogData();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Object attributeModel : this.attributeService.getAttributes()) {
            attributes.add(this.attributeModelConverter.convert((AttributeModel)attributeModel));
        }
        catalogData.setAttributes(attributes);
        ArrayList<Event> events = new ArrayList<Event>();
        for (Object eventModel : this.eventService.getEvents()) {
            events.add(this.eventModelConverter.convert((EventModel)eventModel));
        }
        catalogData.setEvents(events);
        ArrayList<Category> categories = new ArrayList<Category>();
        for (CategoryModel categoryModel : this.categoryService.getCategories()) {
            categories.add(this.categoryModelConverter.convert(categoryModel));
        }
        catalogData.setCategories(categories);
        ArrayList<Product> products = new ArrayList<Product>();
        for (ProductModel productModel : this.productService.getProducts()) {
            products.add(this.productModelConverter.convert(productModel));
        }
        catalogData.setProducts(products);
        this.catalogDao.write(catalogData);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

