/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.chainsaw.ChainsawViewer;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;

public class ChainsawAppender
extends AppenderSkeleton {
    private Appender appender;
    private static ChainsawAppender sSharedAppender = null;
    private String viewerClassname;
    private String hostname = "localhost";
    private String application = "app";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChainsawAppender() {
        super(false);
        Class<ChainsawAppender> clazz = ChainsawAppender.class;
        synchronized (ChainsawAppender.class) {
            if (sSharedAppender == null) {
                sSharedAppender = this;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static ChainsawAppender getInstance() {
        return sSharedAppender;
    }

    public boolean requiresLayout() {
        return false;
    }

    public Appender getAppender() {
        return this.appender;
    }

    public void setAppender(Appender appender) {
        this.appender = appender;
    }

    protected void append(LoggingEvent aEvent) {
        if (this.hostname != null) {
            aEvent.setProperty("hostname", this.hostname);
        }
        if (this.application != null) {
            aEvent.setProperty("application", this.application);
        }
        this.appender.doAppend(aEvent);
    }

    public void activateOptions() {
        ChainsawViewer viewer;
        if (this.viewerClassname == null) {
            this.viewerClassname = "org.apache.log4j.chainsaw.DefaultViewer";
        }
        if ((viewer = (ChainsawViewer)OptionConverter.instantiateByClassName((String)this.viewerClassname, ChainsawViewer.class, null)) != null) {
            viewer.activateViewer(this);
        }
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public void close() {
    }

    public void setViewerClass(String classname) {
        this.viewerClassname = classname;
    }

    public String getViewerClass() {
        return this.viewerClassname;
    }

    public void setApplication(String lapp) {
        this.application = lapp;
    }

    public String getApplication() {
        return this.application;
    }
}

