/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreCache;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamespaceInfoRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamespaceInfoResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.NamenodeHeartbeatRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.NamenodeHeartbeatResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateNamenodeRegistrationRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.UpdateNamenodeRegistrationResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MembershipStoreImpl
extends MembershipStore
implements StateStoreCache {
    private static final Logger LOG = LoggerFactory.getLogger(MembershipStoreImpl.class);
    private final Set<FederationNamespaceInfo> activeNamespaces;
    private final Map<String, MembershipState> activeRegistrations;
    private final Map<String, MembershipState> expiredRegistrations;
    private final ReadWriteLock cacheReadWriteLock = new ReentrantReadWriteLock();
    private final Lock cacheReadLock = this.cacheReadWriteLock.readLock();
    private final Lock cacheWriteLock = this.cacheReadWriteLock.writeLock();

    public MembershipStoreImpl(StateStoreDriver driver) {
        super(driver);
        this.activeRegistrations = new HashMap<String, MembershipState>();
        this.expiredRegistrations = new HashMap<String, MembershipState>();
        this.activeNamespaces = new TreeSet<FederationNamespaceInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetNamenodeRegistrationsResponse getExpiredNamenodeRegistrations(GetNamenodeRegistrationsRequest request) throws IOException {
        GetNamenodeRegistrationsResponse response = GetNamenodeRegistrationsResponse.newInstance();
        this.cacheReadLock.lock();
        try {
            Collection<MembershipState> vals = this.expiredRegistrations.values();
            ArrayList<MembershipState> copyVals = new ArrayList<MembershipState>(vals);
            response.setNamenodeMemberships(copyVals);
        }
        finally {
            this.cacheReadLock.unlock();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetNamespaceInfoResponse getNamespaceInfo(GetNamespaceInfoRequest request) throws IOException {
        HashSet<FederationNamespaceInfo> namespaces = new HashSet<FederationNamespaceInfo>();
        try {
            this.cacheReadLock.lock();
            namespaces.addAll(this.activeNamespaces);
        }
        finally {
            this.cacheReadLock.unlock();
        }
        GetNamespaceInfoResponse response = GetNamespaceInfoResponse.newInstance(namespaces);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetNamenodeRegistrationsResponse getNamenodeRegistrations(GetNamenodeRegistrationsRequest request) throws IOException {
        List<MembershipState> ret = null;
        this.cacheReadLock.lock();
        try {
            Collection<MembershipState> registrations = this.activeRegistrations.values();
            MembershipState partialMembership = request.getPartialMembership();
            if (partialMembership == null) {
                ret = new ArrayList<MembershipState>(registrations);
            } else {
                Query<MembershipState> query = new Query<MembershipState>(partialMembership);
                ret = StateStoreUtils.filterMultiple(query, registrations);
            }
        }
        finally {
            this.cacheReadLock.unlock();
        }
        Collections.sort(ret);
        GetNamenodeRegistrationsResponse response = GetNamenodeRegistrationsResponse.newInstance(ret);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamenodeHeartbeatResponse namenodeHeartbeat(NamenodeHeartbeatRequest request) throws IOException {
        MembershipState record = request.getNamenodeMembership();
        String nnId = record.getNamenodeKey();
        MembershipState existingEntry = null;
        this.cacheReadLock.lock();
        try {
            existingEntry = this.activeRegistrations.get(nnId);
        }
        finally {
            this.cacheReadLock.unlock();
        }
        if (existingEntry != null) {
            if (existingEntry.getState() != record.getState()) {
                LOG.info("NN registration state has changed: {} -> {}", (Object)existingEntry, (Object)record);
            } else {
                LOG.debug("Updating NN registration: {} -> {}", (Object)existingEntry, (Object)record);
            }
        } else {
            LOG.info("Inserting new NN registration: {}", (Object)record);
        }
        boolean status = this.getDriver().put(record, true, false);
        NamenodeHeartbeatResponse response = NamenodeHeartbeatResponse.newInstance(status);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadCache(boolean force) throws IOException {
        super.loadCache(force);
        this.cacheWriteLock.lock();
        try {
            this.activeRegistrations.clear();
            this.expiredRegistrations.clear();
            this.activeNamespaces.clear();
            HashMap<String, LinkedList<MembershipState>> nnRegistrations = new HashMap<String, LinkedList<MembershipState>>();
            List cachedRecords = this.getCachedRecords();
            for (MembershipState membership : cachedRecords) {
                String nnId = membership.getNamenodeKey();
                if (membership.getState() == FederationNamenodeServiceState.EXPIRED) {
                    String key = membership.getPrimaryKey();
                    this.expiredRegistrations.put(key, membership);
                    continue;
                }
                LinkedList<MembershipState> nnRegistration = (LinkedList<MembershipState>)nnRegistrations.get(nnId);
                if (nnRegistration == null) {
                    nnRegistration = new LinkedList<MembershipState>();
                    nnRegistrations.put(nnId, nnRegistration);
                }
                nnRegistration.add(membership);
                String bpId = membership.getBlockPoolId();
                String cId = membership.getClusterId();
                String nsId = membership.getNameserviceId();
                FederationNamespaceInfo nsInfo = new FederationNamespaceInfo(bpId, cId, nsId);
                this.activeNamespaces.add(nsInfo);
            }
            for (List nnRegistration : nnRegistrations.values()) {
                MembershipState representativeRecord = this.getRepresentativeQuorum(nnRegistration);
                String nnKey = representativeRecord.getNamenodeKey();
                this.activeRegistrations.put(nnKey, representativeRecord);
            }
            LOG.debug("Refreshed {} NN registrations from State Store", (Object)cachedRecords.size());
        }
        finally {
            this.cacheWriteLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNamenodeRegistrationResponse updateNamenodeRegistration(UpdateNamenodeRegistrationRequest request) throws IOException {
        boolean status = false;
        this.cacheWriteLock.lock();
        try {
            String namenode = MembershipState.getNamenodeKey(request.getNameserviceId(), request.getNamenodeId());
            MembershipState member = this.activeRegistrations.get(namenode);
            if (member != null) {
                member.setState(request.getState());
                status = true;
            }
        }
        finally {
            this.cacheWriteLock.unlock();
        }
        UpdateNamenodeRegistrationResponse response = UpdateNamenodeRegistrationResponse.newInstance(status);
        return response;
    }

    private MembershipState getRepresentativeQuorum(Collection<MembershipState> records) {
        HashMap<FederationNamenodeServiceState, TreeSet<MembershipState>> occurenceMap = new HashMap<FederationNamenodeServiceState, TreeSet<MembershipState>>();
        for (MembershipState record : records) {
            FederationNamenodeServiceState state = record.getState();
            TreeSet<MembershipState> matchingSet = (TreeSet<MembershipState>)occurenceMap.get((Object)state);
            if (matchingSet == null) {
                matchingSet = new TreeSet<MembershipState>();
                occurenceMap.put(state, matchingSet);
            }
            matchingSet.add(record);
        }
        TreeSet largestSet = new TreeSet();
        for (TreeSet matchingSet : occurenceMap.values()) {
            if (largestSet.size() >= matchingSet.size()) continue;
            largestSet = matchingSet;
        }
        if (largestSet.size() > records.size() / 2) {
            return (MembershipState)largestSet.first();
        }
        if (records.size() > 0) {
            TreeSet<MembershipState> sortedList = new TreeSet<MembershipState>(records);
            LOG.debug("Quorum failed, using most recent: {}", (Object)sortedList.first());
            return sortedList.first();
        }
        return null;
    }
}

