/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.google.inject.Inject;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.HTTPMethods;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebServiceUtil;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class AppsBlock
extends HtmlBlock {
    private final Router router;

    @Inject
    AppsBlock(Router router, View.ViewContext ctx) {
        super(ctx);
        this.router = router;
    }

    protected void render(HtmlBlock.Block html) {
        Configuration conf = this.router.getConfig();
        String webAppAddress = WebAppUtils.getRouterWebAppURLWithScheme((Configuration)conf);
        AppsInfo apps = RouterWebServiceUtil.genericForward(webAppAddress, null, AppsInfo.class, HTTPMethods.GET, "/ws/v1/cluster/apps", null, null);
        this.setTitle("Applications");
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#apps").thead().tr().th(".id", "ID").th(".user", "User").th(".name", "Name").th(".type", "Application Type").th(".queue", "Queue").th(".priority", "Application Priority").th(".starttime", "StartTime").th(".finishtime", "FinishTime").th(".state", "State").th(".finalstatus", "FinalStatus").th(".progress", "Progress").th(".ui", "Tracking UI")._())._()).tbody();
        StringBuilder appsTableData = new StringBuilder("[\n");
        for (AppInfo app : apps.getApps()) {
            try {
                String percent = String.format("%.1f", Float.valueOf(app.getProgress() * 100.0f));
                String trackingURL = app.getTrackingUrl() == null ? "#" : app.getTrackingUrl();
                appsTableData.append("[\"").append("<a href='").append(trackingURL).append("'>").append(app.getAppId()).append("</a>\",\"").append(AppsBlock.escape(app.getUser())).append("\",\"").append(AppsBlock.escape(app.getName())).append("\",\"").append(AppsBlock.escape(app.getApplicationType())).append("\",\"").append(AppsBlock.escape(app.getQueue())).append("\",\"").append(String.valueOf(app.getPriority())).append("\",\"").append(app.getStartTime()).append("\",\"").append(app.getFinishTime()).append("\",\"").append(app.getState()).append("\",\"").append(app.getFinalStatus()).append("\",\"").append("<br title='").append(percent).append("'> <div class='").append(JQueryUI.C_PROGRESSBAR).append("' title='").append(StringHelper.join((Object[])new Object[]{percent, Character.valueOf('%')})).append("'> ").append("<div class='").append(JQueryUI.C_PROGRESSBAR_VALUE).append("' style='").append(StringHelper.join((Object[])new Object[]{"width:", percent, Character.valueOf('%')})).append("'> </div> </div>").append("\",\"<a href='").append(trackingURL).append("'>").append("History").append("</a>");
                appsTableData.append("\"],\n");
            }
            catch (Exception e) {
                LOG.info("Cannot add application {}: {}", (Object)app.getAppId(), (Object)e.getMessage());
            }
        }
        if (appsTableData.charAt(appsTableData.length() - 2) == ',') {
            appsTableData.delete(appsTableData.length() - 2, appsTableData.length() - 1);
        }
        appsTableData.append("]");
        html.script().$type("text/javascript")._(new Object[]{"var appsTableData=" + appsTableData})._();
        ((Hamlet.TABLE)tbody._())._();
    }

    private static String escape(String str) {
        return StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)str));
    }
}

