/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class InclusiveStopFilter
extends FilterBase {
    private byte[] stopRowKey;
    private boolean done = false;

    public InclusiveStopFilter(byte[] stopRowKey) {
        this.stopRowKey = stopRowKey;
    }

    public byte[] getStopRowKey() {
        return this.stopRowKey;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        if (this.done) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public Cell transformCell(Cell v) {
        return v;
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            return this.stopRowKey == null;
        }
        int cmp = Bytes.compareTo((byte[])this.stopRowKey, (int)0, (int)this.stopRowKey.length, (byte[])buffer, (int)offset, (int)length);
        this.done = this.reversed ? cmp > 0 : cmp < 0;
        return this.done;
    }

    @Override
    public boolean filterAllRemaining() {
        return this.done;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 but got: %s", (Object[])new Object[]{filterArguments.size()});
        byte[] stopRowKey = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        return new InclusiveStopFilter(stopRowKey);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.InclusiveStopFilter.Builder builder = FilterProtos.InclusiveStopFilter.newBuilder();
        if (this.stopRowKey != null) {
            builder.setStopRowKey(ByteStringer.wrap((byte[])this.stopRowKey));
        }
        return builder.build().toByteArray();
    }

    public static InclusiveStopFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.InclusiveStopFilter proto;
        try {
            proto = FilterProtos.InclusiveStopFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new InclusiveStopFilter(proto.hasStopRowKey() ? proto.getStopRowKey().toByteArray() : null);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InclusiveStopFilter)) {
            return false;
        }
        InclusiveStopFilter other = (InclusiveStopFilter)o;
        return Bytes.equals((byte[])this.getStopRowKey(), (byte[])other.getStopRowKey());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + Bytes.toStringBinary((byte[])this.stopRowKey);
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Bytes.hashCode((byte[])this.stopRowKey);
    }
}

