/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller.ifile;

import com.google.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.file.tfile.BoundedRangeFileInputStream;
import org.apache.hadoop.io.file.tfile.Compression;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationHtmlBlock;
import org.apache.hadoop.yarn.logaggregation.filecontroller.ifile.LogAggregationIndexedFileController;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletImpl;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class IndexedFileAggregatedLogsBlock
extends LogAggregationHtmlBlock {
    private final LogAggregationIndexedFileController fileController;
    private final Configuration conf;

    @Inject
    public IndexedFileAggregatedLogsBlock(View.ViewContext ctx, Configuration conf, LogAggregationIndexedFileController fileController) {
        super(ctx);
        this.conf = conf;
        this.fileController = fileController;
    }

    @Override
    protected void render(HtmlBlock.Block html) {
        List<FileStatus> fileToRead;
        Map<String, Long> checkSumFiles;
        LogAggregationHtmlBlock.BlockParameters params = this.verifyAndParseParameters(html);
        if (params == null) {
            return;
        }
        ApplicationId appId = params.getAppId();
        ContainerId containerId = params.getContainerId();
        NodeId nodeId = params.getNodeId();
        String appOwner = params.getAppOwner();
        String logEntity = params.getLogEntity();
        long start = params.getStartIndex();
        long end = params.getEndIndex();
        long startTime = params.getStartTime();
        long endTime = params.getEndTime();
        List<FileStatus> nodeFiles = null;
        try {
            nodeFiles = LogAggregationUtils.getRemoteNodeFileList(this.conf, appId, appOwner, this.fileController.getRemoteRootLogDir(), this.fileController.getRemoteRootLogDirSuffix());
        }
        catch (Exception ex) {
            html.h1("Unable to locate any logs for container " + containerId.toString());
            LOG.error(ex.getMessage());
            return;
        }
        try {
            checkSumFiles = this.fileController.parseCheckSumFiles(nodeFiles);
        }
        catch (IOException ex) {
            LOG.error("Error getting logs for " + logEntity, (Throwable)ex);
            html.h1("Error getting logs for " + logEntity);
            return;
        }
        try {
            fileToRead = this.fileController.getNodeLogFileToRead(nodeFiles, nodeId.toString(), appId);
        }
        catch (IOException ex) {
            LOG.error("Error getting logs for " + logEntity, (Throwable)ex);
            html.h1("Error getting logs for " + logEntity);
            return;
        }
        boolean foundLog = false;
        String desiredLogType = this.$("log.type");
        try {
            for (FileStatus thisNodeFile : fileToRead) {
                String remoteUser;
                Long checkSumIndex = checkSumFiles.get(thisNodeFile.getPath().getName());
                long endIndex = -1L;
                if (checkSumIndex != null) {
                    endIndex = checkSumIndex;
                }
                LogAggregationIndexedFileController.IndexedLogsMeta indexedLogsMeta = null;
                try {
                    indexedLogsMeta = this.fileController.loadIndexedLogsMeta(thisNodeFile.getPath(), endIndex, appId);
                }
                catch (Exception ex) {
                    LOG.warn("Can not load log meta from the log file:" + thisNodeFile.getPath());
                    continue;
                }
                if (indexedLogsMeta == null) continue;
                Map<ApplicationAccessType, String> appAcls = indexedLogsMeta.getAcls();
                String user = indexedLogsMeta.getUser();
                if (!this.checkAcls(this.conf, appId, user, appAcls, remoteUser = this.request().getRemoteUser())) {
                    ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"User [" + remoteUser + "] is not authorized to view the logs for " + logEntity + " in log file [" + thisNodeFile.getPath().getName() + "]"}))).__();
                    LOG.error("User [" + remoteUser + "] is not authorized to view the logs for " + logEntity);
                    continue;
                }
                String compressAlgo = indexedLogsMeta.getCompressName();
                ArrayList<LogAggregationIndexedFileController.IndexedFileLogMeta> candidates = new ArrayList<LogAggregationIndexedFileController.IndexedFileLogMeta>();
                for (LogAggregationIndexedFileController.IndexedPerAggregationLogMeta logMeta : indexedLogsMeta.getLogMetas()) {
                    for (Map.Entry<String, List<LogAggregationIndexedFileController.IndexedFileLogMeta>> meta : logMeta.getLogMetas().entrySet()) {
                        for (LogAggregationIndexedFileController.IndexedFileLogMeta log : meta.getValue()) {
                            if (!log.getContainerId().equals(containerId.toString()) || desiredLogType != null && !desiredLogType.isEmpty() && !desiredLogType.equals(log.getFileName())) continue;
                            candidates.add(log);
                        }
                    }
                }
                if (candidates.isEmpty()) continue;
                foundLog = this.readContainerLog(compressAlgo, html, thisNodeFile, start, end, candidates, startTime, endTime, foundLog, logEntity);
            }
            if (!foundLog) {
                if (desiredLogType.isEmpty()) {
                    html.h1("No logs available for container " + containerId.toString());
                } else {
                    html.h1("Unable to locate '" + desiredLogType + "' log for container " + containerId.toString());
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Error getting logs for " + logEntity}))).__();
            LOG.error("Error getting logs for " + logEntity, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean readContainerLog(String compressAlgo, HtmlBlock.Block html, FileStatus thisNodeFile, long start, long end, List<LogAggregationIndexedFileController.IndexedFileLogMeta> candidates, long startTime, long endTime, boolean foundLog, String logEntity) throws IOException {
        Compression.Algorithm compressName = Compression.getCompressionAlgorithmByName((String)compressAlgo);
        Decompressor decompressor = compressName.getDecompressor();
        FileContext fileContext = FileContext.getFileContext((URI)thisNodeFile.getPath().toUri(), (Configuration)this.conf);
        try (FSDataInputStream fsin = fileContext.open(thisNodeFile.getPath());){
            int bufferSize = 65536;
            for (LogAggregationIndexedFileController.IndexedFileLogMeta candidate : candidates) {
                if (candidate.getLastModifiedTime() < startTime || candidate.getLastModifiedTime() > endTime) continue;
                byte[] cbuf = new byte[bufferSize];
                InputStream in = null;
                try {
                    in = compressName.createDecompressionStream((InputStream)new BoundedRangeFileInputStream(fsin, candidate.getStartIndex(), candidate.getFileCompressedSize()), decompressor, LogAggregationIndexedFileController.getFSInputBufferSize(this.conf));
                    long logLength = candidate.getFileSize();
                    ((HamletImpl.EImp)((Object)((Hamlet.PRE)html.pre()).__(new Object[]{"\n\n"}))).__();
                    ((HamletImpl.EImp)((Object)((Hamlet.P)html.p()).__(new Object[]{"Log Type: " + candidate.getFileName()}))).__();
                    ((HamletImpl.EImp)((Object)((Hamlet.P)html.p()).__(new Object[]{"Log Upload Time: " + Times.format(candidate.getLastModifiedTime())}))).__();
                    ((HamletImpl.EImp)((Object)((Hamlet.P)html.p()).__(new Object[]{"Log Length: " + Long.toString(logLength)}))).__();
                    long[] range = this.checkParseRange(html, start, end, startTime, endTime, logLength, candidate.getFileName());
                    this.processContainerLog(html, range, in, bufferSize, cbuf);
                    foundLog = true;
                }
                catch (Exception ex) {
                    try {
                        LOG.error("Error getting logs for " + logEntity, (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeStream(in);
                        throw throwable;
                        return foundLog;
                    }
                    IOUtils.closeStream((Closeable)in);
                    continue;
                }
                IOUtils.closeStream((Closeable)in);
            }
        }
    }
}

