/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.service.api.records.Container;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@ApiModel(description="Containers of a component.")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ComponentContainers
implements Serializable {
    private static final long serialVersionUID = -1456748479118874991L;
    @JsonProperty(value="component_name")
    private String componentName;
    @JsonProperty(value="containers")
    private List<Container> containers;

    @ApiModelProperty(example="null", required=true, value="Name of the component.")
    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String name) {
        this.componentName = name;
    }

    public ComponentContainers name(String name) {
        this.componentName = name;
        return this;
    }

    @ApiModelProperty(example="null", value="Containers of the component.")
    public List<Container> getContainers() {
        return this.containers;
    }

    public void setContainers(List<Container> containers) {
        this.containers = containers;
    }

    public ComponentContainers containers(List<Container> compContainers) {
        this.containers = compContainers;
        return this;
    }

    public void addContainer(Container container) {
        this.containers.add(container);
    }
}

