/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.db;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.db.DBConfiguration;
import org.apache.hadoop.mapreduce.lib.db.DBOutputFormat;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestDBOutputFormat {
    private String[] fieldNames = new String[]{"id", "name", "value"};
    private String[] nullFieldNames = new String[]{null, null, null};
    private String expected = "INSERT INTO hadoop_output (id,name,value) VALUES (?,?,?);";
    private String nullExpected = "INSERT INTO hadoop_output VALUES (?,?,?);";
    private DBOutputFormat<DBWritable, NullWritable> format = new DBOutputFormat();

    @Test
    public void testConstructQuery() {
        String actual = this.format.constructQuery("hadoop_output", this.fieldNames);
        Assert.assertEquals((Object)this.expected, (Object)actual);
        actual = this.format.constructQuery("hadoop_output", this.nullFieldNames);
        Assert.assertEquals((Object)this.nullExpected, (Object)actual);
    }

    @Test
    public void testDB2ConstructQuery() {
        String db2expected = StringUtils.removeEnd((String)this.expected, (String)";");
        String db2nullExpected = StringUtils.removeEnd((String)this.nullExpected, (String)";");
        try {
            Class<?> clazz = this.format.getClass();
            Field field = clazz.getDeclaredField("dbProductName");
            field.setAccessible(true);
            field.set(this.format, "DB2");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Assert.fail((String)e.getMessage());
        }
        String actual = this.format.constructQuery("hadoop_output", this.fieldNames);
        Assert.assertEquals((Object)db2expected, (Object)actual);
        actual = this.format.constructQuery("hadoop_output", this.nullFieldNames);
        Assert.assertEquals((Object)db2nullExpected, (Object)actual);
    }

    @Test
    public void testORACLEConstructQuery() {
        String oracleExpected = StringUtils.removeEnd((String)this.expected, (String)";");
        String oracleNullExpected = StringUtils.removeEnd((String)this.nullExpected, (String)";");
        try {
            Class<?> clazz = this.format.getClass();
            Field field = clazz.getDeclaredField("dbProductName");
            field.setAccessible(true);
            field.set(this.format, "ORACLE");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Assert.fail((String)e.getMessage());
        }
        String actual = this.format.constructQuery("hadoop_output", this.fieldNames);
        Assert.assertEquals((Object)oracleExpected, (Object)actual);
        actual = this.format.constructQuery("hadoop_output", this.nullFieldNames);
        Assert.assertEquals((Object)oracleNullExpected, (Object)actual);
    }

    @Test
    public void testSetOutput() throws IOException {
        Job job = Job.getInstance((Configuration)new Configuration());
        DBOutputFormat.setOutput((Job)job, (String)"hadoop_output", (String[])this.fieldNames);
        DBConfiguration dbConf = new DBConfiguration(job.getConfiguration());
        String actual = this.format.constructQuery(dbConf.getOutputTableName(), dbConf.getOutputFieldNames());
        Assert.assertEquals((Object)this.expected, (Object)actual);
        job = Job.getInstance((Configuration)new Configuration());
        dbConf = new DBConfiguration(job.getConfiguration());
        DBOutputFormat.setOutput((Job)job, (String)"hadoop_output", (int)this.nullFieldNames.length);
        Assert.assertNull((Object)dbConf.getOutputFieldNames());
        Assert.assertEquals((long)this.nullFieldNames.length, (long)dbConf.getOutputFieldCount());
        actual = this.format.constructQuery(dbConf.getOutputTableName(), new String[dbConf.getOutputFieldCount()]);
        Assert.assertEquals((Object)this.nullExpected, (Object)actual);
    }
}

