/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.contracts.exceptions;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADAuthenticator;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AbfsRestOperationException
extends AzureBlobFileSystemException {
    private final int statusCode;
    private final AzureServiceErrorCode errorCode;
    private final String errorMessage;

    public AbfsRestOperationException(int statusCode, String errorCode, String errorMessage, Exception innerException) {
        super("Status code: " + statusCode + " error code: " + errorCode + " error message: " + errorMessage, innerException);
        this.statusCode = statusCode;
        this.errorCode = AzureServiceErrorCode.getAzureServiceCode(this.statusCode, errorCode);
        this.errorMessage = errorMessage;
    }

    public AbfsRestOperationException(int statusCode, String errorCode, String errorMessage, Exception innerException, AbfsHttpOperation abfsHttpOperation) {
        super(AbfsRestOperationException.formatMessage(abfsHttpOperation));
        this.statusCode = statusCode;
        this.errorCode = AzureServiceErrorCode.getAzureServiceCode(this.statusCode, errorCode);
        this.errorMessage = errorMessage;
    }

    public AbfsRestOperationException(AzureADAuthenticator.HttpException innerException) {
        super(innerException.getMessage());
        this.statusCode = innerException.getHttpErrorCode();
        this.errorCode = AzureServiceErrorCode.UNKNOWN;
        this.errorMessage = innerException.getMessage();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public AzureServiceErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private static String formatMessage(AbfsHttpOperation abfsHttpOperation) {
        if (abfsHttpOperation.getMethod().equals("HEAD")) {
            return String.format("Operation failed: \"%1$s\", %2$s, HEAD, %3$s", abfsHttpOperation.getStatusDescription(), abfsHttpOperation.getStatusCode(), abfsHttpOperation.getUrl().toString());
        }
        return String.format("Operation failed: \"%1$s\", %2$s, %3$s, %4$s, %5$s, \"%6$s\"", abfsHttpOperation.getStatusDescription(), abfsHttpOperation.getStatusCode(), abfsHttpOperation.getMethod(), abfsHttpOperation.getUrl().toString(), abfsHttpOperation.getStorageErrorCode(), abfsHttpOperation.getStorageErrorMessage().replaceAll("\\n", " "));
    }
}

