/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;

public class RouterQuotaManager {
    private TreeMap<String, RouterQuotaUsage> cache;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();

    public RouterQuotaManager() {
        this.cache = new TreeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAll() {
        this.readLock.lock();
        try {
            Set<String> set = this.cache.keySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouterQuotaUsage getQuotaUsage(String path) {
        this.readLock.lock();
        try {
            RouterQuotaUsage quotaUsage = this.cache.get(path);
            if (quotaUsage != null && this.isQuotaSet(quotaUsage)) {
                RouterQuotaUsage routerQuotaUsage = quotaUsage;
                return routerQuotaUsage;
            }
            int pos = path.lastIndexOf("/");
            if (pos != -1) {
                String parentPath = path.substring(0, pos);
                RouterQuotaUsage routerQuotaUsage = this.getQuotaUsage(parentPath);
                return routerQuotaUsage;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPaths(String parentPath) {
        this.readLock.lock();
        try {
            String from = parentPath;
            String to = parentPath + '\uffff';
            SortedMap<String, RouterQuotaUsage> subMap = this.cache.subMap(from, to);
            HashSet<String> validPaths = new HashSet<String>();
            if (subMap != null) {
                for (String path : subMap.keySet()) {
                    if (!FederationUtil.isParentEntry(path, parentPath)) continue;
                    validPaths.add(path);
                }
            }
            HashSet<String> hashSet = validPaths;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String path, RouterQuotaUsage quotaUsage) {
        this.writeLock.lock();
        try {
            this.cache.put(path, quotaUsage);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String path) {
        this.writeLock.lock();
        try {
            this.cache.remove(path);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock.lock();
        try {
            this.cache.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isQuotaSet(RouterQuotaUsage quota) {
        if (quota != null) {
            long nsQuota = quota.getQuota();
            long ssQuota = quota.getSpaceQuota();
            if (nsQuota != -1L || ssQuota != -1L) {
                return true;
            }
        }
        return false;
    }
}

