/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.records;

import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreSerializer;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.StateStoreVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RouterState
extends BaseRecord {
    private static final Logger LOG = LoggerFactory.getLogger(RouterState.class);
    private static long expirationMs;

    public static RouterState newInstance() {
        RouterState record = StateStoreSerializer.newRecord(RouterState.class);
        record.init();
        return record;
    }

    public static RouterState newInstance(String addr, long startTime, RouterServiceState status) {
        RouterState record = RouterState.newInstance();
        record.setDateStarted(startTime);
        record.setAddress(addr);
        record.setStatus(status);
        record.setCompileInfo(FederationUtil.getCompileInfo());
        record.setVersion(FederationUtil.getVersion());
        return record;
    }

    public abstract void setAddress(String var1);

    public abstract void setDateStarted(long var1);

    public abstract String getAddress();

    public abstract StateStoreVersion getStateStoreVersion() throws IOException;

    public abstract void setStateStoreVersion(StateStoreVersion var1);

    public abstract RouterServiceState getStatus();

    public abstract void setStatus(RouterServiceState var1);

    public abstract String getVersion();

    public abstract void setVersion(String var1);

    public abstract String getCompileInfo();

    public abstract void setCompileInfo(String var1);

    public abstract long getDateStarted();

    public String getRouterId() {
        return this.getAddress();
    }

    @Override
    public boolean like(BaseRecord o) {
        if (o instanceof RouterState) {
            RouterState other = (RouterState)o;
            if (this.getAddress() != null && !this.getAddress().equals(other.getAddress())) {
                return false;
            }
            return this.getStatus() == null || this.getStatus().equals((Object)other.getStatus());
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getAddress() + " -> " + (Object)((Object)this.getStatus()) + "," + this.getVersion();
    }

    public SortedMap<String, String> getPrimaryKeys() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("address", this.getAddress());
        return map;
    }

    @Override
    public void validate() {
        super.validate();
        if ((this.getAddress() == null || this.getAddress().length() == 0) && this.getStatus() != RouterServiceState.INITIALIZING) {
            throw new IllegalArgumentException("Invalid router entry, no address specified " + this);
        }
    }

    @Override
    public int compareTo(BaseRecord other) {
        if (other == null) {
            return -1;
        }
        if (other instanceof RouterState) {
            RouterState router = (RouterState)other;
            return this.getAddress().compareTo(router.getAddress());
        }
        return super.compareTo(other);
    }

    @Override
    public boolean checkExpired(long currentTime) {
        if (super.checkExpired(currentTime)) {
            this.setStatus(RouterServiceState.EXPIRED);
            return true;
        }
        return false;
    }

    @Override
    public long getExpirationMs() {
        return expirationMs;
    }

    public static void setExpirationMs(long time) {
        expirationMs = time;
    }
}

