/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.reader;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationColumn;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationRowKeyPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnRWHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimelineStorageUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.GenericEntityReader;
import org.apache.hadoop.yarn.webapp.BadRequestException;

class ApplicationEntityReader
extends GenericEntityReader {
    private static final ApplicationTableRW APPLICATION_TABLE = new ApplicationTableRW();

    ApplicationEntityReader(TimelineReaderContext ctxt, TimelineEntityFilters entityFilters, TimelineDataToRetrieve toRetrieve) {
        super(ctxt, entityFilters, toRetrieve);
    }

    ApplicationEntityReader(TimelineReaderContext ctxt, TimelineDataToRetrieve toRetrieve) {
        super(ctxt, toRetrieve);
    }

    @Override
    protected BaseTableRW<?> getTable() {
        return APPLICATION_TABLE;
    }

    @Override
    protected FilterList constructFilterListBasedOnFilters() throws IOException {
        TimelineFilterList infoFilters;
        TimelineFilterList configFilters;
        TimelineFilterList metricFilters;
        TimelineEntityFilters filters = this.getFilters();
        FilterList listBasedOnFilters = new FilterList(new Filter[0]);
        long createdTimeBegin = filters.getCreatedTimeBegin();
        long createdTimeEnd = filters.getCreatedTimeEnd();
        if (createdTimeBegin != 0L || createdTimeEnd != Long.MAX_VALUE) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createSingleColValueFiltersByRange(ApplicationColumn.CREATED_TIME, createdTimeBegin, createdTimeEnd));
        }
        if ((metricFilters = filters.getMetricFilters()) != null && !metricFilters.getFilterList().isEmpty()) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(ApplicationColumnPrefix.METRIC, metricFilters));
        }
        if ((configFilters = filters.getConfigFilters()) != null && !configFilters.getFilterList().isEmpty()) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(ApplicationColumnPrefix.CONFIG, configFilters));
        }
        if ((infoFilters = filters.getInfoFilters()) != null && !infoFilters.getFilterList().isEmpty()) {
            listBasedOnFilters.addFilter((Filter)TimelineFilterUtils.createHBaseFilterList(ApplicationColumnPrefix.INFO, infoFilters));
        }
        return listBasedOnFilters;
    }

    @Override
    protected void updateFixedColumns(FilterList list) {
        for (ApplicationColumn column : ApplicationColumn.values()) {
            list.addFilter((Filter)new QualifierFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(column.getColumnQualifierBytes())));
        }
    }

    private FilterList createFilterListForColsOfInfoFamily() throws IOException {
        FilterList infoFamilyColsFilter = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        this.updateFixedColumns(infoFamilyColsFilter);
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.INFO)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.EQUAL, ApplicationColumnPrefix.INFO));
        }
        TimelineFilterList relatesTo = this.getFilters().getRelatesTo();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.EQUAL, ApplicationColumnPrefix.RELATES_TO));
        } else if (relatesTo != null && !relatesTo.getFilterList().isEmpty()) {
            Set<String> relatesToCols = TimelineFilterUtils.fetchColumnsFromFilterList(relatesTo);
            infoFamilyColsFilter.addFilter((Filter)this.createFiltersFromColumnQualifiers(ApplicationColumnPrefix.RELATES_TO, relatesToCols));
        }
        TimelineFilterList isRelatedTo = this.getFilters().getIsRelatedTo();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.EQUAL, ApplicationColumnPrefix.IS_RELATED_TO));
        } else if (isRelatedTo != null && !isRelatedTo.getFilterList().isEmpty()) {
            Set<String> isRelatedToCols = TimelineFilterUtils.fetchColumnsFromFilterList(isRelatedTo);
            infoFamilyColsFilter.addFilter((Filter)this.createFiltersFromColumnQualifiers(ApplicationColumnPrefix.IS_RELATED_TO, isRelatedToCols));
        }
        TimelineFilterList eventFilters = this.getFilters().getEventFilters();
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS)) {
            infoFamilyColsFilter.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.EQUAL, ApplicationColumnPrefix.EVENT));
        } else if (eventFilters != null && !eventFilters.getFilterList().isEmpty()) {
            Set<String> eventCols = TimelineFilterUtils.fetchColumnsFromFilterList(eventFilters);
            infoFamilyColsFilter.addFilter((Filter)this.createFiltersFromColumnQualifiers(ApplicationColumnPrefix.EVENT, eventCols));
        }
        return infoFamilyColsFilter;
    }

    private void excludeFieldsFromInfoColFamily(FilterList infoColFamilyList) {
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, ApplicationColumnPrefix.EVENT));
        }
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.INFO)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, ApplicationColumnPrefix.INFO));
        }
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, ApplicationColumnPrefix.IS_RELATED_TO));
        }
        if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO)) {
            infoColFamilyList.addFilter(TimelineFilterUtils.createHBaseQualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, ApplicationColumnPrefix.RELATES_TO));
        }
    }

    private void updateFilterForConfsAndMetricsToRetrieve(FilterList listBasedOnFields, Set<String> cfsInFields) throws IOException {
        TimelineDataToRetrieve dataToRetrieve = this.getDataToRetrieve();
        if (dataToRetrieve.getFieldsToRetrieve().contains(TimelineReader.Field.CONFIGS)) {
            listBasedOnFields.addFilter(TimelineFilterUtils.createFilterForConfsOrMetricsToRetrieve(dataToRetrieve.getConfsToRetrieve(), ApplicationColumnFamily.CONFIGS, ApplicationColumnPrefix.CONFIG));
            cfsInFields.add(Bytes.toString((byte[])ApplicationColumnFamily.CONFIGS.getBytes()));
        }
        if (dataToRetrieve.getFieldsToRetrieve().contains(TimelineReader.Field.METRICS)) {
            listBasedOnFields.addFilter(TimelineFilterUtils.createFilterForConfsOrMetricsToRetrieve(dataToRetrieve.getMetricsToRetrieve(), ApplicationColumnFamily.METRICS, ApplicationColumnPrefix.METRIC));
            cfsInFields.add(Bytes.toString((byte[])ApplicationColumnFamily.METRICS.getBytes()));
        }
    }

    @Override
    protected FilterList constructFilterListBasedOnFields(Set<String> cfsInFields) throws IOException {
        if (!this.needCreateFilterListBasedOnFields()) {
            return null;
        }
        FilterList listBasedOnFields = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        FilterList infoColFamilyList = new FilterList(new Filter[0]);
        FamilyFilter infoColumnFamily = new FamilyFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(ApplicationColumnFamily.INFO.getBytes()));
        infoColFamilyList.addFilter((Filter)infoColumnFamily);
        if (!this.isSingleEntityRead() && this.fetchPartialColsFromInfoFamily()) {
            infoColFamilyList.addFilter((Filter)this.createFilterListForColsOfInfoFamily());
        } else {
            this.excludeFieldsFromInfoColFamily(infoColFamilyList);
        }
        listBasedOnFields.addFilter((Filter)infoColFamilyList);
        cfsInFields.add(Bytes.toString((byte[])ApplicationColumnFamily.INFO.getBytes()));
        this.updateFilterForConfsAndMetricsToRetrieve(listBasedOnFields, cfsInFields);
        return listBasedOnFields;
    }

    @Override
    protected Result getResult(Configuration hbaseConf, Connection conn, FilterList filterList) throws IOException {
        TimelineReaderContext context = this.getContext();
        ApplicationRowKey applicationRowKey = new ApplicationRowKey(context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId(), context.getAppId());
        byte[] rowKey = applicationRowKey.getRowKey();
        Get get = new Get(rowKey);
        this.setMetricsTimeRange((Query)get);
        get.setMaxVersions(this.getDataToRetrieve().getMetricsLimit().intValue());
        if (filterList != null && !filterList.getFilters().isEmpty()) {
            get.setFilter((Filter)filterList);
        }
        return this.getTable().getResult(hbaseConf, conn, get);
    }

    @Override
    protected void validateParams() {
        Preconditions.checkNotNull((Object)this.getContext(), (Object)"context shouldn't be null");
        Preconditions.checkNotNull((Object)this.getDataToRetrieve(), (Object)"data to retrieve shouldn't be null");
        Preconditions.checkNotNull((Object)this.getContext().getClusterId(), (Object)"clusterId shouldn't be null");
        Preconditions.checkNotNull((Object)this.getContext().getEntityType(), (Object)"entityType shouldn't be null");
        if (this.isSingleEntityRead()) {
            Preconditions.checkNotNull((Object)this.getContext().getAppId(), (Object)"appId shouldn't be null");
        } else {
            Preconditions.checkNotNull((Object)this.getContext().getUserId(), (Object)"userId shouldn't be null");
            Preconditions.checkNotNull((Object)this.getContext().getFlowName(), (Object)"flowName shouldn't be null");
        }
    }

    @Override
    protected void augmentParams(Configuration hbaseConf, Connection conn) throws IOException {
        if (this.isSingleEntityRead()) {
            this.defaultAugmentParams(hbaseConf, conn);
        }
        this.getDataToRetrieve().addFieldsBasedOnConfsAndMetricsToRetrieve();
        if (!this.isSingleEntityRead()) {
            this.createFiltersIfNull();
        }
    }

    private void setMetricsTimeRange(Query query) {
        HBaseTimelineStorageUtils.setMetricsTimeRange(query, ApplicationColumnFamily.METRICS.getBytes(), this.getDataToRetrieve().getMetricsTimeBegin(), this.getDataToRetrieve().getMetricsTimeEnd());
    }

    @Override
    protected ResultScanner getResults(Configuration hbaseConf, Connection conn, FilterList filterList) throws IOException {
        Scan scan = new Scan();
        TimelineReaderContext context = this.getContext();
        ApplicationRowKeyPrefix applicationRowKeyPrefix = null;
        if (this.getFilters().getFromId() == null) {
            applicationRowKeyPrefix = new ApplicationRowKeyPrefix(context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId());
            scan.setRowPrefixFilter(applicationRowKeyPrefix.getRowKeyPrefix());
        } else {
            ApplicationRowKey applicationRowKey = null;
            try {
                applicationRowKey = ApplicationRowKey.parseRowKeyFromString((String)this.getFilters().getFromId());
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Invalid filter fromid is provided.");
            }
            if (!context.getClusterId().equals(applicationRowKey.getClusterId())) {
                throw new BadRequestException("fromid doesn't belong to clusterId=" + context.getClusterId());
            }
            scan.setStartRow(applicationRowKey.getRowKey());
            applicationRowKeyPrefix = new ApplicationRowKeyPrefix(context.getClusterId(), context.getUserId(), context.getFlowName(), context.getFlowRunId());
            scan.setStopRow(HBaseTimelineStorageUtils.calculateTheClosestNextRowKeyForPrefix(applicationRowKeyPrefix.getRowKeyPrefix()));
        }
        FilterList newList = new FilterList(new Filter[0]);
        newList.addFilter((Filter)new PageFilter(this.getFilters().getLimit()));
        if (filterList != null && !filterList.getFilters().isEmpty()) {
            newList.addFilter((Filter)filterList);
        }
        scan.setFilter((Filter)newList);
        this.setMetricsTimeRange((Query)scan);
        scan.setMaxVersions(this.getDataToRetrieve().getMetricsLimit().intValue());
        return this.getTable().getResultScanner(hbaseConf, conn, scan);
    }

    @Override
    protected TimelineEntity parseEntity(Result result) throws IOException {
        boolean checkEvents;
        boolean checkRelatesTo;
        boolean checkIsRelatedTo;
        if (result == null || result.isEmpty()) {
            return null;
        }
        TimelineEntity entity = new TimelineEntity();
        entity.setType(TimelineEntityType.YARN_APPLICATION.toString());
        String entityId = ColumnRWHelper.readResult(result, ApplicationColumn.ID).toString();
        entity.setId(entityId);
        TimelineEntityFilters filters = this.getFilters();
        Long createdTime = (Long)ColumnRWHelper.readResult(result, ApplicationColumn.CREATED_TIME);
        entity.setCreatedTime(createdTime);
        EnumSet fieldsToRetrieve = this.getDataToRetrieve().getFieldsToRetrieve();
        boolean bl = checkIsRelatedTo = !this.isSingleEntityRead() && filters.getIsRelatedTo() != null && filters.getIsRelatedTo().getFilterList().size() > 0;
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO) || checkIsRelatedTo) {
            this.readRelationship(entity, result, ApplicationColumnPrefix.IS_RELATED_TO, true);
            if (checkIsRelatedTo && !TimelineStorageUtils.matchIsRelatedTo((TimelineEntity)entity, (TimelineFilterList)filters.getIsRelatedTo())) {
                return null;
            }
            if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.IS_RELATED_TO)) {
                entity.getIsRelatedToEntities().clear();
            }
        }
        boolean bl2 = checkRelatesTo = !this.isSingleEntityRead() && filters.getRelatesTo() != null && filters.getRelatesTo().getFilterList().size() > 0;
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO) || checkRelatesTo) {
            this.readRelationship(entity, result, ApplicationColumnPrefix.RELATES_TO, false);
            if (checkRelatesTo && !TimelineStorageUtils.matchRelatesTo((TimelineEntity)entity, (TimelineFilterList)filters.getRelatesTo())) {
                return null;
            }
            if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.RELATES_TO)) {
                entity.getRelatesToEntities().clear();
            }
        }
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.INFO)) {
            this.readKeyValuePairs(entity, result, ApplicationColumnPrefix.INFO, false);
        }
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.CONFIGS)) {
            this.readKeyValuePairs(entity, result, ApplicationColumnPrefix.CONFIG, true);
        }
        boolean bl3 = checkEvents = !this.isSingleEntityRead() && filters.getEventFilters() != null && filters.getEventFilters().getFilterList().size() > 0;
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS) || checkEvents) {
            ApplicationEntityReader.readEvents(entity, result, ApplicationColumnPrefix.EVENT);
            if (checkEvents && !TimelineStorageUtils.matchEventFilters((TimelineEntity)entity, (TimelineFilterList)filters.getEventFilters())) {
                return null;
            }
            if (!this.hasField(fieldsToRetrieve, TimelineReader.Field.EVENTS)) {
                entity.getEvents().clear();
            }
        }
        if (this.hasField(fieldsToRetrieve, TimelineReader.Field.METRICS)) {
            this.readMetrics(entity, result, (ColumnPrefix<?>)ApplicationColumnPrefix.METRIC);
        }
        ApplicationRowKey rowKey = ApplicationRowKey.parseRowKey((byte[])result.getRow());
        entity.getInfo().put("FROM_ID", rowKey.getRowKeyAsString());
        return entity;
    }
}

