/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import com.codahale.metrics.Counter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingWindowReservoir;
import com.codahale.metrics.Timer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.sls.scheduler.CapacitySchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.FairSchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.FifoSchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerWrapper;
import org.apache.hadoop.yarn.sls.web.SLSWebApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class SchedulerMetrics {
    private static final String EOL = System.getProperty("line.separator");
    private static final int SAMPLING_SIZE = 60;
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerMetrics.class);
    protected ResourceScheduler scheduler;
    protected Set<String> trackedQueues;
    protected MetricRegistry metrics = new MetricRegistry();
    protected Set<String> appTrackedMetrics = new HashSet<String>();
    protected Set<String> queueTrackedMetrics;
    private Configuration conf;
    private ScheduledExecutorService pool;
    private SLSWebApp web;
    private String metricsOutputDir;
    private BufferedWriter metricsLogBW;
    private BufferedWriter jobRuntimeLogBW;
    private boolean running = false;
    private Counter schedulerAllocateCounter;
    private Counter schedulerHandleCounter;
    private Map<SchedulerEventType, Counter> schedulerHandleCounterMap;
    private Timer schedulerAllocateTimer;
    private Timer schedulerHandleTimer;
    private Map<SchedulerEventType, Timer> schedulerHandleTimerMap;
    private List<Histogram> schedulerHistogramList;
    private Map<Histogram, Timer> histogramTimerMap;
    private Lock samplerLock;
    private Lock queueLock;

    static Class getSchedulerMetricsClass(Configuration conf, Class schedulerClass) throws ClassNotFoundException {
        Class<Object> metricClass = null;
        String schedulerMetricsType = conf.get(schedulerClass.getName());
        if (schedulerMetricsType != null) {
            metricClass = Class.forName(schedulerMetricsType);
        }
        if (schedulerClass.equals(FairScheduler.class)) {
            metricClass = FairSchedulerMetrics.class;
        } else if (schedulerClass.equals(CapacityScheduler.class)) {
            metricClass = CapacitySchedulerMetrics.class;
        } else if (schedulerClass.equals(FifoScheduler.class)) {
            metricClass = FifoSchedulerMetrics.class;
        }
        return metricClass;
    }

    static SchedulerMetrics getInstance(Configuration conf, Class schedulerClass) throws ClassNotFoundException {
        Class schedulerMetricClass = SchedulerMetrics.getSchedulerMetricsClass(conf, schedulerClass);
        return (SchedulerMetrics)ReflectionUtils.newInstance((Class)schedulerMetricClass, (Configuration)new Configuration());
    }

    public SchedulerMetrics() {
        this.appTrackedMetrics.add("live.containers");
        this.appTrackedMetrics.add("reserved.containers");
        this.queueTrackedMetrics = new HashSet<String>();
        this.trackedQueues = new HashSet<String>();
        this.samplerLock = new ReentrantLock();
        this.queueLock = new ReentrantLock();
    }

    void init(ResourceScheduler resourceScheduler, Configuration config) throws Exception {
        this.scheduler = resourceScheduler;
        this.conf = config;
        this.metricsOutputDir = this.conf.get("yarn.sls.metrics.output");
        this.registerJvmMetrics();
        this.registerClusterResourceMetrics();
        this.registerContainerAppNumMetrics();
        this.registerSchedulerMetrics();
        this.initMetricsCSVOutput();
        int metricsWebAddressPort = this.conf.getInt("yarn.sls.metrics.web.address.port", 10001);
        this.web = new SLSWebApp((SchedulerWrapper)this.scheduler, metricsWebAddressPort);
        this.web.start();
        this.pool = new ScheduledThreadPoolExecutor(2);
        this.pool.scheduleAtFixedRate(new HistogramsRunnable(), 0L, 1000L, TimeUnit.MILLISECONDS);
        this.pool.scheduleAtFixedRate(new MetricsLogRunnable(), 0L, 1000L, TimeUnit.MILLISECONDS);
        this.jobRuntimeLogBW = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.metricsOutputDir + "/jobruntime.csv"), "UTF-8"));
        this.jobRuntimeLogBW.write("JobID,real_start_time,real_end_time,simulate_start_time,simulate_end_time" + EOL);
        this.jobRuntimeLogBW.flush();
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    protected SchedulerApplicationAttempt getSchedulerAppAttempt(ApplicationId appId) {
        AbstractYarnScheduler yarnScheduler = (AbstractYarnScheduler)this.scheduler;
        SchedulerApplication app = (SchedulerApplication)yarnScheduler.getSchedulerApplications().get(appId);
        if (app == null) {
            return null;
        }
        return app.getCurrentAppAttempt();
    }

    public void trackApp(final ApplicationId appId, String oldAppId) {
        this.metrics.register("variable.app." + oldAppId + ".live.containers", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                SchedulerApplicationAttempt appAttempt = SchedulerMetrics.this.getSchedulerAppAttempt(appId);
                if (appAttempt != null) {
                    return appAttempt.getLiveContainers().size();
                }
                return 0;
            }
        });
        this.metrics.register("variable.app." + oldAppId + ".reserved.containers", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                SchedulerApplicationAttempt appAttempt = SchedulerMetrics.this.getSchedulerAppAttempt(appId);
                if (appAttempt != null) {
                    return appAttempt.getReservedContainers().size();
                }
                return 0;
            }
        });
    }

    public void untrackApp(String oldAppId) {
        for (String m : this.appTrackedMetrics) {
            this.metrics.remove("variable.app." + oldAppId + "." + m);
        }
    }

    public abstract void trackQueue(String var1);

    public void untrackQueue(String queueName) {
        for (String m : this.queueTrackedMetrics) {
            this.metrics.remove("variable.queue." + queueName + "." + m);
        }
    }

    public boolean isTracked(String queueName) {
        return this.trackedQueues.contains(queueName);
    }

    public Set<String> getAppTrackedMetrics() {
        return this.appTrackedMetrics;
    }

    public Set<String> getQueueTrackedMetrics() {
        return this.queueTrackedMetrics;
    }

    private void registerJvmMetrics() {
        this.metrics.register("variable.jvm.free.memory", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return Runtime.getRuntime().freeMemory();
            }
        });
        this.metrics.register("variable.jvm.max.memory", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return Runtime.getRuntime().maxMemory();
            }
        });
        this.metrics.register("variable.jvm.total.memory", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return Runtime.getRuntime().totalMemory();
            }
        });
    }

    private void registerClusterResourceMetrics() {
        this.metrics.register("variable.cluster.allocated.memory", (Metric)new Gauge<Long>(){

            public Long getValue() {
                if (SchedulerMetrics.this.scheduler.getRootQueueMetrics() == null) {
                    return 0L;
                }
                return SchedulerMetrics.this.scheduler.getRootQueueMetrics().getAllocatedMB();
            }
        });
        this.metrics.register("variable.cluster.allocated.vcores", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                if (SchedulerMetrics.this.scheduler.getRootQueueMetrics() == null) {
                    return 0;
                }
                return SchedulerMetrics.this.scheduler.getRootQueueMetrics().getAllocatedVirtualCores();
            }
        });
        this.metrics.register("variable.cluster.available.memory", (Metric)new Gauge<Long>(){

            public Long getValue() {
                if (SchedulerMetrics.this.scheduler.getRootQueueMetrics() == null) {
                    return 0L;
                }
                return SchedulerMetrics.this.scheduler.getRootQueueMetrics().getAvailableMB();
            }
        });
        this.metrics.register("variable.cluster.available.vcores", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                if (SchedulerMetrics.this.scheduler.getRootQueueMetrics() == null) {
                    return 0;
                }
                return SchedulerMetrics.this.scheduler.getRootQueueMetrics().getAvailableVirtualCores();
            }
        });
    }

    private void registerContainerAppNumMetrics() {
        this.metrics.register("variable.running.application", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                if (SchedulerMetrics.this.scheduler.getRootQueueMetrics() == null) {
                    return 0;
                }
                return SchedulerMetrics.this.scheduler.getRootQueueMetrics().getAppsRunning();
            }
        });
        this.metrics.register("variable.running.container", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                if (SchedulerMetrics.this.scheduler.getRootQueueMetrics() == null) {
                    return 0;
                }
                return SchedulerMetrics.this.scheduler.getRootQueueMetrics().getAllocatedContainers();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSchedulerMetrics() {
        this.samplerLock.lock();
        try {
            this.schedulerAllocateCounter = this.metrics.counter("counter.scheduler.operation.allocate");
            this.schedulerHandleCounter = this.metrics.counter("counter.scheduler.operation.handle");
            this.schedulerHandleCounterMap = new HashMap<SchedulerEventType, Counter>();
            for (SchedulerEventType e : SchedulerEventType.values()) {
                Counter counter = this.metrics.counter("counter.scheduler.operation.handle." + e);
                this.schedulerHandleCounterMap.put(e, counter);
            }
            int timeWindowSize = this.conf.getInt("yarn.sls.metrics.timer.window.size", 100);
            this.schedulerAllocateTimer = new Timer((Reservoir)new SlidingWindowReservoir(timeWindowSize));
            this.schedulerHandleTimer = new Timer((Reservoir)new SlidingWindowReservoir(timeWindowSize));
            this.schedulerHandleTimerMap = new HashMap<SchedulerEventType, Timer>();
            for (SchedulerEventType e : SchedulerEventType.values()) {
                Timer timer = new Timer((Reservoir)new SlidingWindowReservoir(timeWindowSize));
                this.schedulerHandleTimerMap.put(e, timer);
            }
            this.schedulerHistogramList = new ArrayList<Histogram>();
            this.histogramTimerMap = new HashMap<Histogram, Timer>();
            Histogram schedulerAllocateHistogram = new Histogram((Reservoir)new SlidingWindowReservoir(60));
            this.metrics.register("sampler.scheduler.operation.allocate.timecost", (Metric)schedulerAllocateHistogram);
            this.schedulerHistogramList.add(schedulerAllocateHistogram);
            this.histogramTimerMap.put(schedulerAllocateHistogram, this.schedulerAllocateTimer);
            Histogram schedulerHandleHistogram = new Histogram((Reservoir)new SlidingWindowReservoir(60));
            this.metrics.register("sampler.scheduler.operation.handle.timecost", (Metric)schedulerHandleHistogram);
            this.schedulerHistogramList.add(schedulerHandleHistogram);
            this.histogramTimerMap.put(schedulerHandleHistogram, this.schedulerHandleTimer);
            for (SchedulerEventType e : SchedulerEventType.values()) {
                Histogram histogram = new Histogram((Reservoir)new SlidingWindowReservoir(60));
                this.metrics.register("sampler.scheduler.operation.handle." + e + ".timecost", (Metric)histogram);
                this.schedulerHistogramList.add(histogram);
                this.histogramTimerMap.put(histogram, this.schedulerHandleTimerMap.get(e));
            }
        }
        finally {
            this.samplerLock.unlock();
        }
    }

    private void initMetricsCSVOutput() {
        int timeIntervalMS = this.conf.getInt("yarn.sls.metrics.record.interval.ms", 1000);
        File dir = new File(this.metricsOutputDir + "/metrics");
        if (!dir.exists() && !dir.mkdirs()) {
            LOG.error("Cannot create directory {}", (Object)dir.getAbsoluteFile());
        }
        CsvReporter reporter = CsvReporter.forRegistry((MetricRegistry)this.metrics).formatFor(Locale.US).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(new File(this.metricsOutputDir + "/metrics"));
        reporter.start((long)timeIntervalMS, TimeUnit.MILLISECONDS);
    }

    boolean isRunning() {
        return this.running;
    }

    void setRunning(boolean running) {
        this.running = running;
    }

    void tearDown() throws Exception {
        if (this.metricsLogBW != null) {
            this.metricsLogBW.write("]");
            this.metricsLogBW.close();
        }
        if (this.web != null) {
            this.web.stop();
        }
        if (this.jobRuntimeLogBW != null) {
            this.jobRuntimeLogBW.close();
        }
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    void increaseSchedulerAllocationCounter() {
        this.schedulerAllocateCounter.inc();
    }

    void increaseSchedulerHandleCounter(SchedulerEventType schedulerEventType) {
        this.schedulerHandleCounter.inc();
        this.schedulerHandleCounterMap.get(schedulerEventType).inc();
    }

    Timer getSchedulerAllocateTimer() {
        return this.schedulerAllocateTimer;
    }

    Timer getSchedulerHandleTimer() {
        return this.schedulerHandleTimer;
    }

    Timer getSchedulerHandleTimer(SchedulerEventType schedulerEventType) {
        return this.schedulerHandleTimerMap.get(schedulerEventType);
    }

    private String getQueueMetricName(String queue, QueueMetric metric) {
        return "counter.queue." + queue + "." + metric.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceQueueIfNotTraced(String queue) {
        this.queueLock.lock();
        try {
            if (!this.isTracked(queue)) {
                this.trackQueue(queue);
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    void initQueueMetric(String queueName) {
        SortedMap counterMap = this.metrics.getCounters();
        for (QueueMetric queueMetric : QueueMetric.values()) {
            String metricName = this.getQueueMetricName(queueName, queueMetric);
            if (counterMap.containsKey(metricName)) continue;
            this.metrics.counter(metricName);
            counterMap = this.metrics.getCounters();
        }
        this.traceQueueIfNotTraced(queueName);
    }

    void updateQueueMetrics(Resource pendingResource, Resource allocatedResource, String queueName) {
        SortedMap counterMap = this.metrics.getCounters();
        for (QueueMetric metric : QueueMetric.values()) {
            String metricName = this.getQueueMetricName(queueName, metric);
            if (!counterMap.containsKey(metricName)) {
                this.metrics.counter(metricName);
                counterMap = this.metrics.getCounters();
            }
            if (metric == QueueMetric.PENDING_MEMORY) {
                ((Counter)counterMap.get(metricName)).inc(pendingResource.getMemorySize());
                continue;
            }
            if (metric == QueueMetric.PENDING_VCORES) {
                ((Counter)counterMap.get(metricName)).inc((long)pendingResource.getVirtualCores());
                continue;
            }
            if (metric == QueueMetric.ALLOCATED_MEMORY) {
                ((Counter)counterMap.get(metricName)).inc(allocatedResource.getMemorySize());
                continue;
            }
            if (metric != QueueMetric.ALLOCATED_VCORES) continue;
            ((Counter)counterMap.get(metricName)).inc((long)allocatedResource.getVirtualCores());
        }
        this.traceQueueIfNotTraced(queueName);
    }

    void updateQueueMetricsByRelease(Resource releaseResource, String queue) {
        String name;
        SortedMap counterMap = this.metrics.getCounters();
        if (!counterMap.containsKey(name = this.getQueueMetricName(queue, QueueMetric.ALLOCATED_MEMORY))) {
            this.metrics.counter(name);
            counterMap = this.metrics.getCounters();
        }
        ((Counter)counterMap.get(name)).inc(-releaseResource.getMemorySize());
        String vcoreMetric = this.getQueueMetricName(queue, QueueMetric.ALLOCATED_VCORES);
        if (!counterMap.containsKey(vcoreMetric)) {
            this.metrics.counter(vcoreMetric);
            counterMap = this.metrics.getCounters();
        }
        ((Counter)counterMap.get(vcoreMetric)).inc((long)(-releaseResource.getVirtualCores()));
    }

    public void addTrackedApp(ApplicationId appId, String oldAppId) {
        this.trackApp(appId, oldAppId);
    }

    public void removeTrackedApp(String oldAppId) {
        this.untrackApp(oldAppId);
    }

    public void addAMRuntime(ApplicationId appId, long traceStartTimeMS, long traceEndTimeMS, long simulateStartTimeMS, long simulateEndTimeMS) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(appId).append(",").append(traceStartTimeMS).append(",").append(traceEndTimeMS).append(",").append(simulateStartTimeMS).append(",").append(simulateEndTimeMS);
            this.jobRuntimeLogBW.write(sb.toString() + EOL);
            this.jobRuntimeLogBW.flush();
        }
        catch (IOException e) {
            LOG.info(e.getMessage());
        }
    }

    private static enum QueueMetric {
        PENDING_MEMORY("pending.memory"),
        PENDING_VCORES("pending.cores"),
        ALLOCATED_MEMORY("allocated.memory"),
        ALLOCATED_VCORES("allocated.cores");

        private String value;

        private QueueMetric(String value) {
            this.value = value;
        }
    }

    class MetricsLogRunnable
    implements Runnable {
        private boolean firstLine = true;

        MetricsLogRunnable() {
            try {
                SchedulerMetrics.this.metricsLogBW = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(SchedulerMetrics.this.metricsOutputDir + "/realtimetrack.json"), "UTF-8"));
                SchedulerMetrics.this.metricsLogBW.write("[");
            }
            catch (IOException e) {
                LOG.info(e.getMessage());
            }
        }

        @Override
        public void run() {
            if (SchedulerMetrics.this.running) {
                String trackingMetrics = SchedulerMetrics.this.web.generateRealTimeTrackingMetrics();
                try {
                    if (this.firstLine) {
                        SchedulerMetrics.this.metricsLogBW.write(trackingMetrics + EOL);
                        this.firstLine = false;
                    } else {
                        SchedulerMetrics.this.metricsLogBW.write("," + trackingMetrics + EOL);
                    }
                    SchedulerMetrics.this.metricsLogBW.flush();
                }
                catch (IOException e) {
                    LOG.info(e.getMessage());
                }
            }
        }
    }

    class HistogramsRunnable
    implements Runnable {
        HistogramsRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SchedulerMetrics.this.samplerLock.lock();
            try {
                for (Histogram histogram : SchedulerMetrics.this.schedulerHistogramList) {
                    Timer timer = (Timer)SchedulerMetrics.this.histogramTimerMap.get(histogram);
                    histogram.update((int)timer.getSnapshot().getMean());
                }
            }
            finally {
                SchedulerMetrics.this.samplerLock.unlock();
            }
        }
    }
}

