/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestUGILoginFromKeytab {
    private MiniKdc kdc;
    private File workDir;
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();

    @Before
    public void startMiniKdc() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.workDir = this.folder.getRoot();
        this.kdc = new MiniKdc(MiniKdc.createConf(), this.workDir);
        this.kdc.start();
    }

    @After
    public void stopMiniKdc() {
        if (this.kdc != null) {
            this.kdc.stop();
        }
    }

    @Test
    public void testUGILoginFromKeytab() throws Exception {
        long beforeLogin = Time.now();
        String principal = "foo";
        File keytab = new File(this.workDir, "foo.keytab");
        this.kdc.createPrincipal(keytab, new String[]{principal});
        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab.getPath());
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        Assert.assertTrue((String)"UGI should be configured to login from keytab", (boolean)ugi.isFromKeytab());
        User user = ugi.getSubject().getPrincipals(User.class).iterator().next();
        Assert.assertNotNull((Object)user.getLogin());
        Assert.assertTrue((String)("User login time is less than before login time, beforeLoginTime:" + beforeLogin + " userLoginTime:" + user.getLastLogin()), (user.getLastLogin() > beforeLogin ? 1 : 0) != 0);
    }

    @Test
    public void testUGIReloginFromKeytab() throws Exception {
        UserGroupInformation.setShouldRenewImmediatelyForTests((boolean)true);
        String principal = "foo";
        File keytab = new File(this.workDir, "foo.keytab");
        this.kdc.createPrincipal(keytab, new String[]{principal});
        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab.getPath());
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        Assert.assertTrue((String)"UGI should be configured to login from keytab", (boolean)ugi.isFromKeytab());
        User user = ugi.getSubject().getPrincipals(User.class).iterator().next();
        long firstLogin = user.getLastLogin();
        Thread.sleep(2000L);
        ugi.reloginFromKeytab();
        long secondLogin = user.getLastLogin();
        Assert.assertTrue((String)"User should have been able to relogin from keytab", (secondLogin > firstLogin ? 1 : 0) != 0);
    }

    @Test
    public void testUGIForceReLoginFromKeytab() throws Exception {
        UserGroupInformation.setShouldRenewImmediatelyForTests((boolean)true);
        String principal = "foo";
        File keytab = new File(this.workDir, "foo.keytab");
        this.kdc.createPrincipal(keytab, new String[]{principal});
        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab.getPath());
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        Assert.assertTrue((String)"UGI should be configured to login from keytab", (boolean)ugi.isFromKeytab());
        User user = ugi.getSubject().getPrincipals(User.class).iterator().next();
        long firstLogin = user.getLastLogin();
        LoginContext login1 = user.getLogin();
        Assert.assertNotNull((Object)login1);
        Thread.sleep(2000L);
        ugi.forceReloginFromKeytab();
        long secondLogin = user.getLastLogin();
        LoginContext login2 = user.getLogin();
        Assert.assertTrue((String)"User should have been able to relogin from keytab", (secondLogin > firstLogin ? 1 : 0) != 0);
        Assert.assertNotNull((Object)login2);
        Assert.assertNotSame((Object)login1, (Object)login2);
    }
}

