/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.List;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class ReservationInputValidator {
    private final Clock clock;

    public ReservationInputValidator(Clock clock) {
        this.clock = clock;
    }

    private Plan validateReservation(ReservationSystem reservationSystem, ReservationId reservationId, String auditConstant) throws YarnException {
        if (reservationId == null) {
            String message = "Missing reservation id. Please try again by specifying a reservation id.";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        String queue = reservationSystem.getQueueForReservation(reservationId);
        String nullQueueErrorMessage = "The specified reservation with ID: " + reservationId + " is unknown. Please try again with a valid reservation.";
        String nullPlanErrorMessage = "The specified reservation: " + reservationId + " is not associated with any valid plan." + " Please try again with a valid reservation.";
        return this.getPlanFromQueue(reservationSystem, queue, auditConstant, nullQueueErrorMessage, nullPlanErrorMessage);
    }

    private void validateReservationDefinition(ReservationId reservationId, ReservationDefinition contract, Plan plan, String auditConstant) throws YarnException {
        String message = "";
        if (contract == null) {
            message = "Missing reservation definition. Please try again by specifying a reservation definition.";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input definition", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        if (contract.getDeadline() <= this.clock.getTime()) {
            message = "The specified deadline: " + contract.getDeadline() + " is the past. Please try again with deadline in the future.";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input definition", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        ReservationRequests resReqs = contract.getReservationRequests();
        if (resReqs == null) {
            message = "No resources have been specified to reserve.Please try again by specifying the resources to reserve.";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input definition", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        List resReq = resReqs.getReservationResources();
        if (resReq == null || resReq.isEmpty()) {
            message = "No resources have been specified to reserve. Please try again by specifying the resources to reserve.";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input definition", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        long minDuration = 0L;
        Resource maxGangSize = Resource.newInstance((int)0, (int)0);
        ReservationRequestInterpreter type = contract.getReservationRequests().getInterpreter();
        for (ReservationRequest rr : resReq) {
            minDuration = type == ReservationRequestInterpreter.R_ALL || type == ReservationRequestInterpreter.R_ANY ? Math.max(minDuration, rr.getDuration()) : (minDuration += rr.getDuration());
            maxGangSize = Resources.max((ResourceCalculator)plan.getResourceCalculator(), (Resource)plan.getTotalCapacity(), (Resource)maxGangSize, (Resource)Resources.multiply((Resource)rr.getCapability(), (double)rr.getConcurrency()));
        }
        long duration = contract.getDeadline() - contract.getArrival();
        if (duration < minDuration && type != ReservationRequestInterpreter.R_ANY) {
            message = "The time difference (" + duration + ") between arrival (" + contract.getArrival() + ") " + "and deadline (" + contract.getDeadline() + ") must " + " be greater or equal to the minimum resource duration (" + minDuration + ")";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input definition", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        if (Resources.greaterThan((ResourceCalculator)plan.getResourceCalculator(), (Resource)plan.getTotalCapacity(), (Resource)maxGangSize, (Resource)plan.getTotalCapacity()) && type != ReservationRequestInterpreter.R_ANY) {
            message = "The size of the largest gang in the reservation definition (" + maxGangSize + ") exceed the capacity available (" + plan.getTotalCapacity() + " )";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input definition", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        String recurrenceExpression = contract.getRecurrenceExpression();
        try {
            long recurrence = Long.parseLong(recurrenceExpression);
            if (recurrence < 0L) {
                message = "Negative Period : " + recurrenceExpression + ". Please try" + " again with a non-negative long value as period.";
                throw RPCUtil.getRemoteException((String)message);
            }
            if (recurrence > 0L && duration > recurrence) {
                message = "Duration of the requested reservation: " + duration + " is greater than the recurrence: " + recurrence + ". Please try again with a smaller duration.";
                throw RPCUtil.getRemoteException((String)message);
            }
            if (recurrence > 0L && plan.getMaximumPeriodicity() % recurrence != 0L) {
                message = "The maximum periodicity: " + plan.getMaximumPeriodicity() + " must be divisible by the recurrence expression provided: " + recurrence + ". Please try again with a recurrence expression" + " that satisfies this requirement.";
                throw RPCUtil.getRemoteException((String)message);
            }
        }
        catch (NumberFormatException e) {
            message = "Invalid period " + recurrenceExpression + ". Please try" + " again with a non-negative long value as period.";
            throw RPCUtil.getRemoteException((String)message);
        }
    }

    private Plan getPlanFromQueue(ReservationSystem reservationSystem, String queue, String auditConstant) throws YarnException {
        String nullQueueErrorMessage = "The queue is not specified. Please try again with a valid reservable queue.";
        String nullPlanErrorMessage = "The specified queue: " + queue + " is not managed by reservation system." + " Please try again with a valid reservable queue.";
        return this.getPlanFromQueue(reservationSystem, queue, auditConstant, nullQueueErrorMessage, nullPlanErrorMessage);
    }

    private Plan getPlanFromQueue(ReservationSystem reservationSystem, String queue, String auditConstant, String nullQueueErrorMessage, String nullPlanErrorMessage) throws YarnException {
        if (queue == null || queue.isEmpty()) {
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input", "ClientRMService", nullQueueErrorMessage);
            throw RPCUtil.getRemoteException((String)nullQueueErrorMessage);
        }
        Plan plan = reservationSystem.getPlan(queue);
        if (plan == null) {
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input", "ClientRMService", nullPlanErrorMessage);
            throw RPCUtil.getRemoteException((String)nullPlanErrorMessage);
        }
        return plan;
    }

    public Plan validateReservationSubmissionRequest(ReservationSystem reservationSystem, ReservationSubmissionRequest request, ReservationId reservationId) throws YarnException {
        if (reservationId == null) {
            String message = "Reservation id cannot be null. Please try again specifying  a valid reservation id by creating a new reservation id.";
            throw RPCUtil.getRemoteException((String)message);
        }
        String queue = request.getQueue();
        Plan plan = this.getPlanFromQueue(reservationSystem, queue, "Submit Reservation Request");
        this.validateReservationDefinition(reservationId, request.getReservationDefinition(), plan, "Submit Reservation Request");
        return plan;
    }

    public Plan validateReservationUpdateRequest(ReservationSystem reservationSystem, ReservationUpdateRequest request) throws YarnException {
        ReservationId reservationId = request.getReservationId();
        Plan plan = this.validateReservation(reservationSystem, reservationId, "Update Reservation Request");
        this.validateReservationDefinition(reservationId, request.getReservationDefinition(), plan, "Update Reservation Request");
        return plan;
    }

    public Plan validateReservationListRequest(ReservationSystem reservationSystem, ReservationListRequest request) throws YarnException {
        String queue = request.getQueue();
        if (request.getEndTime() < request.getStartTime()) {
            String errorMessage = "The specified end time must be greater than the specified start time.";
            RMAuditLogger.logFailure("UNKNOWN", "List Reservation Request", "validate list reservation input", "ClientRMService", errorMessage);
            throw RPCUtil.getRemoteException((String)errorMessage);
        }
        return this.getPlanFromQueue(reservationSystem, queue, "List Reservation Request");
    }

    public Plan validateReservationDeleteRequest(ReservationSystem reservationSystem, ReservationDeleteRequest request) throws YarnException {
        return this.validateReservation(reservationSystem, request.getReservationId(), "Delete Reservation Request");
    }
}

