/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class SubstituteBackwards
extends MatrixOperation {
    public static final SubstituteBackwards SETUP = new SubstituteBackwards();
    public static int THRESHOLD = 64;

    public static void invoke(BigDecimal[] data, int structure, int firstColumn, int columnLimit, Access2D<BigDecimal> body, boolean unitDiagonal, boolean conjugated, boolean hermitian) {
        int tmpDiagDim = (int)Math.min(body.countRows(), body.countColumns());
        BigDecimal[] tmpBodyRow = new BigDecimal[tmpDiagDim];
        int tmpFirstRow = hermitian ? firstColumn : 0;
        for (int i = tmpDiagDim - 1; i >= tmpFirstRow; --i) {
            for (int j = i; j < tmpDiagDim; ++j) {
                tmpBodyRow[j] = conjugated ? body.get(j, i) : body.get(i, j);
            }
            int tmpColumnLimit = hermitian ? Math.min(i + 1, columnLimit) : columnLimit;
            for (int s = firstColumn; s < tmpColumnLimit; ++s) {
                int tmpColBaseIndex = s * structure;
                BigDecimal tmpVal = BigMath.ZERO;
                for (int j = i + 1; j < tmpDiagDim; ++j) {
                    tmpVal = tmpVal.add(tmpBodyRow[j].multiply(data[j + tmpColBaseIndex]));
                }
                tmpVal = data[i + tmpColBaseIndex].subtract(tmpVal);
                if (!unitDiagonal) {
                    tmpVal = BigFunction.DIVIDE.invoke(tmpVal, tmpBodyRow[i]);
                }
                data[i + tmpColBaseIndex] = tmpVal;
            }
        }
    }

    public static void invoke(ComplexNumber[] data, int structure, int firstColumn, int columnLimit, Access2D<ComplexNumber> body, boolean unitDiagonal, boolean conjugated, boolean hermitian) {
        int tmpDiagDim = (int)Math.min(body.countRows(), body.countColumns());
        ComplexNumber[] tmpBodyRow = new ComplexNumber[tmpDiagDim];
        int tmpFirstRow = hermitian ? firstColumn : 0;
        for (int i = tmpDiagDim - 1; i >= tmpFirstRow; --i) {
            for (int j = i; j < tmpDiagDim; ++j) {
                tmpBodyRow[j] = conjugated ? body.get(j, i).conjugate() : body.get(i, j);
            }
            int tmpColumnLimit = hermitian ? Math.min(i + 1, columnLimit) : columnLimit;
            for (int s = firstColumn; s < tmpColumnLimit; ++s) {
                int tmpColBaseIndex = s * structure;
                ComplexNumber tmpVal = ComplexNumber.ZERO;
                for (int j = i + 1; j < tmpDiagDim; ++j) {
                    tmpVal = tmpVal.add(tmpBodyRow[j].multiply(data[j + tmpColBaseIndex]));
                }
                tmpVal = data[i + tmpColBaseIndex].subtract(tmpVal);
                if (!unitDiagonal) {
                    tmpVal = tmpVal.divide(tmpBodyRow[i]);
                }
                data[i + tmpColBaseIndex] = tmpVal;
            }
        }
    }

    public static void invoke(double[] data, int structure, int firstColumn, int columnLimit, Access2D<Double> body, boolean unitDiagonal, boolean conjugated, boolean hermitian) {
        int tmpDiagDim = (int)Math.min(body.countRows(), body.countColumns());
        double[] tmpBodyRow = new double[tmpDiagDim];
        int tmpFirstRow = hermitian ? firstColumn : 0;
        for (int i = tmpDiagDim - 1; i >= tmpFirstRow; --i) {
            for (int j = i; j < tmpDiagDim; ++j) {
                tmpBodyRow[j] = conjugated ? body.doubleValue(j, i) : body.doubleValue(i, j);
            }
            int tmpColumnLimit = hermitian ? Math.min(i + 1, columnLimit) : columnLimit;
            for (int s = firstColumn; s < tmpColumnLimit; ++s) {
                int tmpColBaseIndex = s * structure;
                double tmpVal = PrimitiveMath.ZERO;
                for (int j = i + 1; j < tmpDiagDim; ++j) {
                    tmpVal += tmpBodyRow[j] * data[j + tmpColBaseIndex];
                }
                tmpVal = data[i + tmpColBaseIndex] - tmpVal;
                if (!unitDiagonal) {
                    tmpVal /= tmpBodyRow[i];
                }
                data[i + tmpColBaseIndex] = tmpVal;
            }
        }
    }

    private SubstituteBackwards() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

