
use strict;
#use diagnostics;
use Test::More;

use NetAddr::IP::Lite;
use NetAddr::IP::Util qw(
	bcd2bin
	bin2bcd
	addconst
	shiftleft
);

use Data::Dumper;

sub badd {	# function to add a small int to bignum string
  my($n,$i) = @_;
  my $v = bcd2bin($n);
  (undef,$v) = addconst($v,$i);
  bin2bcd($v);
}

sub xpo2 {	# function to do a n^2 multiplication
  my($n,$x) = @_;
  my $v = bcd2bin($n);
  my $c = 0;
  while ($x >>= 1) {$c++}
  $v = shiftleft($v,$c);
  bin2bcd($v);
}

my $no_mbi_emu = 1;	# set this to "1" for normal, "0" for development

unless (eval{ $no_mbi_emu && require Math::BigInt }) {
  if ($no_mbi_emu) {
    print "1..1\nok 1	# skipped all, Math::BigInt not found\n";
    exit;
  }

  &NetAddr::IP::Lite::_force_bi_emu;

  package Math::BigInt;
  my $badd = \&main::badd;
  require overload;
  import overload 
	'""'	=> sub {
	${$_[0]} =~ /(\d+)/;
	return $1;
 	},
	'+'	=> sub {
	${$_[0]} =~ /(\d+)/;
	$b = '+'. main::badd($1,$_[1]);
	bless \$b;
	};
  *new = \&NetAddr::IP::Lite::_bi_fake;
}

my @exp = (qw(
	255.255.255.253/32				4294967293				4294967295
	255.255.255.254/32				4294967294				4294967295
	255.255.255.255/32				4294967295				4294967295
	0:0:0:0:0:1:0:0/128				4294967296				4294967295
	0:0:0:0:0:1:0:1/128				4294967297				4294967295
	0:0:0:0:0:1:0:2/128				4294967298				4294967295
	FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFD/128	340282366920938463463374607431768211453	340282366920938463463374607431768211455
	FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFE/128	340282366920938463463374607431768211454	340282366920938463463374607431768211455
	FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF/128	340282366920938463463374607431768211455	340282366920938463463374607431768211455
	0.0.0.0/32					0					4294967295
	0.0.0.1/32					1					4294967295
	0.0.0.2/32					2					4294967295
	123.45.67.89/32					2066563929				4294967295
	123.45.67.89/28					2066563929				4294967280
	123.45.67.89/24					2066563929				4294967040
	123.45.67.89/20					2066563929				4294963200
	123.45.67.89/16					2066563929				4294901760
	123.45.67.89/12					2066563929				4293918720
	123.45.67.89/8					2066563929				4278190080
	123.45.67.89/4					2066563929				4026531840
	123.45.67.89/0					2066563929				0
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/128		170145699920964442595609400891477785294	340282366920938463463374607431768211455
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/124		170145699920964442595609400891477785294	340282366920938463463374607431768211440
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/120		170145699920964442595609400891477785294	340282366920938463463374607431768211200
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/116		170145699920964442595609400891477785294	340282366920938463463374607431768207360
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/112		170145699920964442595609400891477785294	340282366920938463463374607431768145920
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/108		170145699920964442595609400891477785294	340282366920938463463374607431767162880
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/104		170145699920964442595609400891477785294	340282366920938463463374607431751434240
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/100		170145699920964442595609400891477785294	340282366920938463463374607431499776000
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/96		170145699920964442595609400891477785294	340282366920938463463374607427473244160
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/92		170145699920964442595609400891477785294	340282366920938463463374607363048734720
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/88		170145699920964442595609400891477785294	340282366920938463463374606332256583680
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/84		170145699920964442595609400891477785294	340282366920938463463374589839582167040
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/80		170145699920964442595609400891477785294	340282366920938463463374325956791500800
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/76		170145699920964442595609400891477785294	340282366920938463463370103832140840960
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/72		170145699920964442595609400891477785294	340282366920938463463302549837730283520
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/68		170145699920964442595609400891477785294	340282366920938463462221685927161364480
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/64		170145699920964442595609400891477785294	340282366920938463444927863358058659840
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/60		170145699920964442595609400891477785294	340282366920938463168226702252415385600
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/56		170145699920964442595609400891477785294	340282366920938458741008124562122997760
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/52		170145699920964442595609400891477785294	340282366920938387905510881517444792320
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/48		170145699920964442595609400891477785294	340282366920937254537554992802593505280
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/44		170145699920964442595609400891477785294	340282366920919120650260773364972912640
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/40		170145699920964442595609400891477785294	340282366920628978453553262363043430400
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/36		170145699920964442595609400891477785294	340282366915986703306233086332171714560
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/32		170145699920964442595609400891477785294	340282366841710300949110269838224261120
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/28		170145699920964442595609400891477785294	340282365653287863235145205935065006080
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/24		170145699920964442595609400891477785294	340282346638528859811704183484516925440
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/20		170145699920964442595609400891477785294	340282042402384805036647824275747635200
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/16		170145699920964442595609400891477785294	340277174624079928635746076935438991360
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/12		170145699920964442595609400891477785294	340199290171201906221318119490500689920
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/8		170145699920964442595609400891477785294	338953138925153547590470800371487866880
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/4		170145699920964442595609400891477785294	319014718988379809496913694467282698240
	8000:DEAD:BEEF:4:CAFE:BAD:2:FACE/0		170145699920964442595609400891477785294	0
));

my $ptr = 0;
my $max = @exp -11;
plan tests => $max || 1;

sub run {
  foreach(1..5) {
    my $ip = new NetAddr::IP::Lite($exp[$ptr]);
    my $mbi = $ip->bigint();
    $mbi = $mbi + 1;
#print $ip,"\n";
#print Dumper $mbi;
#print $exp[$ptr+1],"\n";
    like($mbi, qr/(?:0|$exp[$ptr+4])/);
    $ip = new NetAddr::IP::Lite($mbi);
    is($ip, $exp[$ptr+3]);
    pass();				# ignore mask for these tests
    $ptr += 3;
  }
}

run();
$ptr += 3;
run();

$ptr += 3;

sub mrun {
  my $n = shift;
  foreach(1..$n) {
    my $ip = new NetAddr::IP::Lite($exp[$ptr]);
    my ($mbia,$mbim) = $ip->bigint();
    my($ary,$msk,$eip) = @exp[$ptr+1,$ptr+2,$ptr+3];
    $ptr += 3;
#print $msk,"\n";
#print Dumper $mbia;
#print Dumper $mbim;
    like($mbia, qr/$ary/);
    like($mbim, qr/$msk/);
    my $len = $ip->masklen();
    last unless $len;
    last if $ptr > $max + 200;		# loop stop, just in case
#print Dumper $mbim;
    $mbim = new Math::BigInt($exp[$ptr+2]);
#print Dumper $mbim;
#print Dumper $mbia;
    $ip = new NetAddr::IP::Lite($mbia,$mbim);
    is($ip, $eip);
#print '|',$ip,"|\n";
  }
}

mrun(9);

$ptr += 3;

mrun(32);
