# Generated by default/object.tt
package Paws::NimbleStudio::LaunchProfile;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has CreatedBy => (is => 'ro', isa => 'Str', request_name => 'createdBy', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Ec2SubnetIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'ec2SubnetIds', traits => ['NameInRequest']);
  has LaunchProfileId => (is => 'ro', isa => 'Str', request_name => 'launchProfileId', traits => ['NameInRequest']);
  has LaunchProfileProtocolVersions => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'launchProfileProtocolVersions', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest']);
  has StatusCode => (is => 'ro', isa => 'Str', request_name => 'statusCode', traits => ['NameInRequest']);
  has StatusMessage => (is => 'ro', isa => 'Str', request_name => 'statusMessage', traits => ['NameInRequest']);
  has StreamConfiguration => (is => 'ro', isa => 'Paws::NimbleStudio::StreamConfiguration', request_name => 'streamConfiguration', traits => ['NameInRequest']);
  has StudioComponentIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'studioComponentIds', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'Paws::NimbleStudio::Tags', request_name => 'tags', traits => ['NameInRequest']);
  has UpdatedAt => (is => 'ro', isa => 'Str', request_name => 'updatedAt', traits => ['NameInRequest']);
  has UpdatedBy => (is => 'ro', isa => 'Str', request_name => 'updatedBy', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NimbleStudio::LaunchProfile

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NimbleStudio::LaunchProfile object:

  $service_obj->Method(Att1 => { Arn => $value, ..., UpdatedBy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NimbleStudio::LaunchProfile object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

This class has no description

=head1 ATTRIBUTES


=head2 Arn => Str

The ARN of the resource.


=head2 CreatedAt => Str

The Unix epoch timestamp in seconds for when the resource was created.


=head2 CreatedBy => Str

The user ID of the user that created the launch profile.


=head2 Description => Str

A human-readable description of the launch profile.


=head2 Ec2SubnetIds => ArrayRef[Str|Undef]

Unique identifiers for a collection of EC2 subnets.


=head2 LaunchProfileId => Str

The launch profile ID.


=head2 LaunchProfileProtocolVersions => ArrayRef[Str|Undef]

The version number of the protocol that is used by the launch profile.
The only valid version is "2021-03-31".


=head2 Name => Str

A friendly name for the launch profile.


=head2 State => Str

The current state.


=head2 StatusCode => Str

The status code.


=head2 StatusMessage => Str

The status message for the launch profile.


=head2 StreamConfiguration => L<Paws::NimbleStudio::StreamConfiguration>

A configuration for a streaming session.


=head2 StudioComponentIds => ArrayRef[Str|Undef]

Unique identifiers for a collection of studio components that can be
used with this launch profile.


=head2 Tags => L<Paws::NimbleStudio::Tags>

A collection of labels, in the form of key:value pairs, that apply to
this resource.


=head2 UpdatedAt => Str

The Unix epoch timestamp in seconds for when the resource was updated.


=head2 UpdatedBy => Str

The user ID of the user that most recently updated the resource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NimbleStudio>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

