/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.registry;

import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileEncoder;
import javax.media.jai.tilecodec.TileEncoderFactory;

public final class TileEncoderRegistry {
    private static final String MODE_NAME = "tileEncoder";

    public static void register(OperationRegistry operationRegistry, String string, String string2, TileEncoderFactory tileEncoderFactory) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.registerFactory(MODE_NAME, string, string2, tileEncoderFactory);
    }

    public static void unregister(OperationRegistry operationRegistry, String string, String string2, TileEncoderFactory tileEncoderFactory) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.unregisterFactory(MODE_NAME, string, string2, tileEncoderFactory);
    }

    public static void setPreference(OperationRegistry operationRegistry, String string, String string2, TileEncoderFactory tileEncoderFactory, TileEncoderFactory tileEncoderFactory2) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.setFactoryPreference(MODE_NAME, string, string2, tileEncoderFactory, tileEncoderFactory2);
    }

    public static void unsetPreference(OperationRegistry operationRegistry, String string, String string2, TileEncoderFactory tileEncoderFactory, TileEncoderFactory tileEncoderFactory2) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.unsetFactoryPreference(MODE_NAME, string, string2, tileEncoderFactory, tileEncoderFactory2);
    }

    public static void clearPreferences(OperationRegistry operationRegistry, String string, String string2) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.clearFactoryPreferences(MODE_NAME, string, string2);
    }

    public static List getOrderedList(OperationRegistry operationRegistry, String string, String string2) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        return operationRegistry.getOrderedFactoryList(MODE_NAME, string, string2);
    }

    public static Iterator getIterator(OperationRegistry operationRegistry, String string) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        return operationRegistry.getFactoryIterator(MODE_NAME, string);
    }

    public static TileEncoderFactory get(OperationRegistry operationRegistry, String string) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        return (TileEncoderFactory)operationRegistry.getFactory(MODE_NAME, string);
    }

    public static TileEncoder create(OperationRegistry operationRegistry, String string, OutputStream outputStream, TileCodecParameterList tileCodecParameterList, SampleModel sampleModel) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        Object[] objectArray = new Object[]{outputStream, tileCodecParameterList, sampleModel};
        return (TileEncoder)operationRegistry.invokeFactory(MODE_NAME, string, objectArray);
    }

    public static void encode(OperationRegistry operationRegistry, String string, Raster raster, OutputStream outputStream, TileCodecParameterList tileCodecParameterList) throws IOException {
        TileEncoder tileEncoder = TileEncoderRegistry.create(operationRegistry, string, outputStream, tileCodecParameterList, raster.getSampleModel());
        if (tileEncoder != null) {
            tileEncoder.encode(raster);
        }
    }
}

