/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset.filter;

import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;

public class LogicalFilterComposer {
    public static CrawlableDatasetFilter getAndFilter(CrawlableDatasetFilter filter1, CrawlableDatasetFilter filter2) {
        return new AndFilter(filter1, filter2);
    }

    public static CrawlableDatasetFilter getOrFilter(CrawlableDatasetFilter filter1, CrawlableDatasetFilter filter2) {
        return new OrFilter(filter1, filter2);
    }

    public static CrawlableDatasetFilter getNotFilter(CrawlableDatasetFilter filter) {
        return new NotFilter(filter);
    }

    private static class NotFilter
    implements CrawlableDatasetFilter {
        private CrawlableDatasetFilter filter;

        NotFilter(CrawlableDatasetFilter filter1) {
            this.filter = filter1;
        }

        public boolean accept(CrawlableDataset dataset) {
            return !this.filter.accept(dataset);
        }

        public Object getConfigObject() {
            return null;
        }
    }

    private static class OrFilter
    implements CrawlableDatasetFilter {
        private CrawlableDatasetFilter filter1;
        private CrawlableDatasetFilter filter2;

        OrFilter(CrawlableDatasetFilter filter1, CrawlableDatasetFilter filter2) {
            this.filter1 = filter1;
            this.filter2 = filter2;
        }

        public boolean accept(CrawlableDataset dataset) {
            return this.filter1.accept(dataset) || this.filter2.accept(dataset);
        }

        public Object getConfigObject() {
            return null;
        }
    }

    private static class AndFilter
    implements CrawlableDatasetFilter {
        private CrawlableDatasetFilter filter1;
        private CrawlableDatasetFilter filter2;

        AndFilter(CrawlableDatasetFilter filter1, CrawlableDatasetFilter filter2) {
            this.filter1 = filter1;
            this.filter2 = filter2;
        }

        public boolean accept(CrawlableDataset dataset) {
            return this.filter1.accept(dataset) && this.filter2.accept(dataset);
        }

        public Object getConfigObject() {
            return null;
        }
    }
}

