/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.function;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.function.PDDictionaryFunction;

public class PDFunctionType2
extends PDDictionaryFunction {
    private COSArray C0;
    private COSArray C1;

    protected PDFunctionType2() {
        super(2);
    }

    public PDFunctionType2(COSDictionary functionDictionary) {
        super(functionDictionary);
    }

    public COSArray Eval(COSArray input) throws IOException {
        double x = input.toFloatArray()[0];
        COSArray y = new COSArray();
        for (int j = 0; j < this.getC0().size(); ++j) {
            float FofX = (float)((double)((COSFloat)this.C0.get(j)).floatValue() + Math.pow(x, this.getN()) * (double)(((COSFloat)this.C1.get(j)).floatValue() - ((COSFloat)this.C0.get(j)).floatValue()));
            y.add(new COSFloat(FofX));
        }
        return y;
    }

    protected COSArray getC0() {
        if (this.C0 == null) {
            this.C0 = this.getRangeArray("C0", 1);
        }
        return this.C0;
    }

    protected COSArray getC1() {
        if (this.C1 == null) {
            this.C1 = (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.getPDFName("C1"));
            if (this.C1 == null) {
                this.C1 = new COSArray();
                this.getCOSDictionary().setItem("C1", (COSBase)this.C1);
                this.C1.add(new COSFloat(1.0f));
            }
        }
        return this.C1;
    }

    protected float getN() {
        return this.getCOSDictionary().getFloat("N");
    }
}

