#!perl
use strict;
use Test::More (tests => 27);
BEGIN
{
    use_ok("DateTime::Format::Japanese", ':constants');
}
use Encode;

my @params = (
    [
        DateTime->new(year => 2004, month => 1, day => 29, hour => 11, minute => 49, second => 34),
        {
            "ʿϻǯͶʬ" =>
                [ FORMAT_KANJI, FORMAT_ERA, 0, 0, 0 ],
            "ʿϻǯ󽽶ͽʬ" =>
                [ FORMAT_KANJI_WITH_UNIT, FORMAT_ERA, 0, 0, 0 ],
            "ʿǯʬ" =>
                [ FORMAT_ZENKAKU, FORMAT_ERA, 0, 0, 0 ],
            "ʿ16ǯ1291149ʬ34" =>
                [ FORMAT_ROMAN, FORMAT_ERA, 0, 0, 0 ],
            "ʿǯʬ" =>
                [ FORMAT_ZENKAKU, FORMAT_ERA, 0, 0, 0, 1 ],
            "ʿ16ǯ1291149ʬ34" =>
                [ FORMAT_ROMAN, FORMAT_ERA, 0, 0, 0 ],
            "2004ǯ1291149ʬ34" =>
                [ FORMAT_ROMAN, FORMAT_GREGORIAN, 0, 0, 0 ],
            "2004ǯ1291149ʬ34" =>
                [ FORMAT_ROMAN, FORMAT_GREGORIAN, 1, 0, 0 ],
            "2004ǯ1291149ʬ34" =>
                [ FORMAT_ROMAN, FORMAT_GREGORIAN, 1, 0, 1 ],
            "󡻡ǯͶʬ" =>
                [ FORMAT_KANJI, FORMAT_GREGORIAN, 1, 0, 0 ],
            "󡻡ǯ󽽶ͽʬ" =>
                [ FORMAT_KANJI_WITH_UNIT, FORMAT_GREGORIAN, 0, 0, 0 ],
        }
    ],
    [
        DateTime->new(year => -2004, month => 1, day => 29, hour => 11, minute => 49, second => 34),
        {
            "-󡻡ǯͶʬ" =>
                [ FORMAT_KANJI, FORMAT_GREGORIAN, 0, 0, 0 ],
            "-󡻡ǯͶʬ" =>
                [ FORMAT_KANJI, FORMAT_GREGORIAN, 1, 0, 0 ],
            "󡻡ǯͶʬ" =>
                [ FORMAT_KANJI, FORMAT_GREGORIAN, 1, 1, 0 ],
        }
    ]
            
);

my($dt, $str, $fmt);
foreach my $param (@params) {
    $fmt = DateTime::Format::Japanese->new();
    
    while (my($expected, $args) = each %{$param->[1]}) {
        $fmt->number_format($args->[0]);
        $fmt->year_format($args->[1]);
        $fmt->with_gregorian_marker($args->[2]);
        $fmt->with_bc_marker($args->[3]);
        $fmt->with_ampm_marker($args->[4]);
        $fmt->with_day_of_week($args->[5]);
        $str = $fmt->format_datetime($param->[0]);

        is(encode('euc-jp', $str), $expected, "Test " . $param->[0]->datetime . " = " . $expected);

        $dt = $fmt->parse_datetime($str);
        is($param->[0]->compare($dt), 0, "Test parsing back result");
    }
}

