# Generated by default/object.tt
package Paws::MediaTailor::ScheduleEntry;
  use Moose;
  has ApproximateDurationSeconds => (is => 'ro', isa => 'Int');
  has ApproximateStartTime => (is => 'ro', isa => 'Str');
  has Arn => (is => 'ro', isa => 'Str', required => 1);
  has ChannelName => (is => 'ro', isa => 'Str', required => 1);
  has ProgramName => (is => 'ro', isa => 'Str', required => 1);
  has ScheduleAdBreaks => (is => 'ro', isa => 'ArrayRef[Paws::MediaTailor::ScheduleAdBreak]');
  has SourceLocationName => (is => 'ro', isa => 'Str', required => 1);
  has VodSourceName => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaTailor::ScheduleEntry

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaTailor::ScheduleEntry object:

  $service_obj->Method(Att1 => { ApproximateDurationSeconds => $value, ..., VodSourceName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaTailor::ScheduleEntry object:

  $result = $service_obj->Method(...);
  $result->Att1->ApproximateDurationSeconds

=head1 DESCRIPTION

The properties for a schedule.

=head1 ATTRIBUTES


=head2 ApproximateDurationSeconds => Int

The approximate duration of this program, in seconds.


=head2 ApproximateStartTime => Str

The approximate time that the program will start playing.


=head2 B<REQUIRED> Arn => Str

The ARN of the program.


=head2 B<REQUIRED> ChannelName => Str

The name of the channel that uses this schedule.


=head2 B<REQUIRED> ProgramName => Str

The name of the program.


=head2 ScheduleAdBreaks => ArrayRef[L<Paws::MediaTailor::ScheduleAdBreak>]

The schedule's ad break properties.


=head2 B<REQUIRED> SourceLocationName => Str

The name of the source location.


=head2 B<REQUIRED> VodSourceName => Str

The name of the VOD source.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaTailor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

