package Net::Amazon::EMR::HadoopStepConfig;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;

has 'Args' => ( is => 'ro', 
                isa => 'Net::Amazon::EMR::Type::ArrayRefofUnconstrainedStr',
                coerce => 1,
 );

has 'Jar' => ( is => 'ro', 
               isa => 'Str' );

has 'MainClass' => ( is => 'ro', 
                     isa => 'Str' );

has 'Properties' => ( is => 'ro', 
                      isa => 'HashRef'
    );

__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::HadoopStepConfig

=head1 DESCRIPTION

Implements the HadoopStepConfig data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_HadoopStepConfig.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
