package Net::Amazon::EMR::Cluster;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Net::Amazon::EMR::Application;
use Net::Amazon::EMR::Configuration;
use Net::Amazon::EMR::Ec2InstanceAttributes;
use Net::Amazon::EMR::ClusterStatus;
use Net::Amazon::EMR::Tag;

has 'Applications' => ( is => 'ro',
                    isa => 'Net::Amazon::EMR::Type::ArrayRefofApplication',
                    coerce => 1 );

has 'AutoTerminate' => ( is => 'ro', 
                         isa => 'Net::Amazon::EMR::Type::Bool',
                         coerce => 1, );

has 'Configurations' => ( is => 'ro',
                          isa => 'Net::Amazon::EMR::Type::ArrayRefofConfiguration',
                          coerce => 1,
                      );

has 'Ec2InstanceAttributes' => ( is => 'ro',
                                 isa => 'Net::Amazon::EMR::Type::Ec2InstanceAttributes',
                                 coerce => 1,
                             );

has 'Id' => ( is => 'ro', 
              isa => 'Str' );

has 'LogUri' => ( is => 'ro', 
              isa => 'Str' );

has 'MasterPublicDnsName' => ( is => 'ro', 
                               isa => 'Str' );

has 'Name' => ( is => 'ro', 
                isa => 'Str' );

has 'NormalisedInstanceHours' => ( is => 'ro', 
                                   isa => 'Int' );

has 'ReleaseLabel' => ( is => 'ro', 
                        isa => 'Str' );

has 'RequestedAmiVersion' => ( is => 'ro', 
                             isa => 'Str' );

has 'RunningAmiVersion' => ( is => 'ro', 
                             isa => 'Str' );

has 'ServiceRole' => ( is => 'ro', 
                       isa => 'Str' );

has 'Status' => ( is => 'ro',
                  isa => 'Net::Amazon::EMR::Type::ClusterStatus',
                  coerce => 1,
              );

has 'Tags' => ( is => 'ro',
                isa => 'Net::Amazon::EMR::Type::ArrayRefofTag',
                coerce => 1,
            );

has 'TerminationProtected' => ( is => 'ro', 
                                isa => 'Net::Amazon::EMR::Type::Bool',
                                coerce => 1,
                            );

has 'VisibleToAllUsers' => ( is => 'ro', 
                             isa => 'Net::Amazon::EMR::Type::Bool',
                             coerce => 1,
                         );

__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::Cluster

=head1 DESCRIPTION

Implements the Cluster data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_Cluster.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
