#!./perl -w

chdir 't' if -d 't';
@INC = '../lib';
require './test.pl';
use strict;

$|=1;

run_multiple_progs('', \*DATA);

foreach my $code ('sub;', 'sub ($) ;', '{ $x = sub }', 'sub ($) && 1') {
    eval $code;
    like($@, qr/^Illegal declaration of anonymous subroutine at/,
	 "'$code' is illegal");
}

{
    local $::TODO;
    $::TODO = 'RT #17589 not completely resolved';
    # Here's a patch. It makes "sub;" and similar report an error immediately
    # from the lexer. However the solution is not complete, it doesn't
    # handle the case "sub ($) : lvalue;" (marked as a TODO test), because
    # it's handled by the lexer in separate tokens, hence more difficult to
    # work out.
    my $code = 'sub ($) : lvalue;';
    eval $code;
    like($@, qr/^Illegal declaration of anonymous subroutine at/,
	 "'$code' is illegal");
}

eval "sub #foo\n{print 1}";
is($@, '');

done_testing();

__END__
sub X {
    my $n = "ok 1\n";
    sub { print $n };
}
my $x = X();
undef &X;
$x->();
EXPECT
ok 1
########
sub X {
    my $n = "ok 1\n";
    sub {
        my $dummy = $n;	# eval can't close on $n without internal reference
	eval 'print $n';
	die $@ if $@;
    };
}
my $x = X();
undef &X;
$x->();
EXPECT
ok 1
########
sub X {
    my $n = "ok 1\n";
    eval 'sub { print $n }';
}
my $x = X();
die $@ if $@;
undef &X;
$x->();
EXPECT
ok 1
########
sub X;
sub X {
    my $n = "ok 1\n";
    eval 'sub Y { my $p = shift; $p->() }';
    die $@ if $@;
    Y(sub { print $n });
}
X();
EXPECT
ok 1
########
print sub { return "ok 1\n" } -> ();
EXPECT
ok 1
