# Generated by default/object.tt
package Paws::AutoScaling::InstanceRefreshProgressDetails;
  use Moose;
  has LivePoolProgress => (is => 'ro', isa => 'Paws::AutoScaling::InstanceRefreshLivePoolProgress');
  has WarmPoolProgress => (is => 'ro', isa => 'Paws::AutoScaling::InstanceRefreshWarmPoolProgress');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AutoScaling::InstanceRefreshProgressDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AutoScaling::InstanceRefreshProgressDetails object:

  $service_obj->Method(Att1 => { LivePoolProgress => $value, ..., WarmPoolProgress => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AutoScaling::InstanceRefreshProgressDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->LivePoolProgress

=head1 DESCRIPTION

Reports the progress of an instance refresh on an Auto Scaling group
that has a warm pool. This includes separate details for instances in
the warm pool and instances in the Auto Scaling group (the live pool).

=head1 ATTRIBUTES


=head2 LivePoolProgress => L<Paws::AutoScaling::InstanceRefreshLivePoolProgress>

Indicates the progress of an instance refresh on instances that are in
the Auto Scaling group.


=head2 WarmPoolProgress => L<Paws::AutoScaling::InstanceRefreshWarmPoolProgress>

Indicates the progress of an instance refresh on instances that are in
the warm pool.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AutoScaling>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

