# Generated by default/object.tt
package Paws::Glue::OtherMetadataValueListItem;
  use Moose;
  has CreatedTime => (is => 'ro', isa => 'Str');
  has MetadataValue => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::OtherMetadataValueListItem

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::OtherMetadataValueListItem object:

  $service_obj->Method(Att1 => { CreatedTime => $value, ..., MetadataValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::OtherMetadataValueListItem object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedTime

=head1 DESCRIPTION

A structure containing other metadata for a schema version belonging to
the same metadata key.

=head1 ATTRIBUTES


=head2 CreatedTime => Str

The time at which the entry was created.


=head2 MetadataValue => Str

The metadata keyE<rsquo>s corresponding value for the other metadata
belonging to the same metadata key.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

