# Generated by default/object.tt
package Paws::ApplicationMigration::DataReplicationInfo;
  use Moose;
  has DataReplicationError => (is => 'ro', isa => 'Paws::ApplicationMigration::DataReplicationError', request_name => 'dataReplicationError', traits => ['NameInRequest']);
  has DataReplicationInitiation => (is => 'ro', isa => 'Paws::ApplicationMigration::DataReplicationInitiation', request_name => 'dataReplicationInitiation', traits => ['NameInRequest']);
  has DataReplicationState => (is => 'ro', isa => 'Str', request_name => 'dataReplicationState', traits => ['NameInRequest']);
  has EtaDateTime => (is => 'ro', isa => 'Str', request_name => 'etaDateTime', traits => ['NameInRequest']);
  has LagDuration => (is => 'ro', isa => 'Str', request_name => 'lagDuration', traits => ['NameInRequest']);
  has ReplicatedDisks => (is => 'ro', isa => 'ArrayRef[Paws::ApplicationMigration::DataReplicationInfoReplicatedDisk]', request_name => 'replicatedDisks', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApplicationMigration::DataReplicationInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApplicationMigration::DataReplicationInfo object:

  $service_obj->Method(Att1 => { DataReplicationError => $value, ..., ReplicatedDisks => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApplicationMigration::DataReplicationInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->DataReplicationError

=head1 DESCRIPTION

Request data replication info.

=head1 ATTRIBUTES


=head2 DataReplicationError => L<Paws::ApplicationMigration::DataReplicationError>

Error in obtaining data replication info.


=head2 DataReplicationInitiation => L<Paws::ApplicationMigration::DataReplicationInitiation>

Request to query whether data replication has been initiated.


=head2 DataReplicationState => Str

Request to query the data replication state.


=head2 EtaDateTime => Str

Request to query the time when data replication will be complete.


=head2 LagDuration => Str

Request to query data replication lag durating.


=head2 ReplicatedDisks => ArrayRef[L<Paws::ApplicationMigration::DataReplicationInfoReplicatedDisk>]

Request to query disks replicated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApplicationMigration>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

