# Quick-start guide to hacking on Apache Lucy.

The Apache Lucy code base is organized into roughly four layers:

* Charmonizer - compiler and OS configuration probing.
* Clownfish - header files.
* C - implementation files.
* Host - binding language.

Charmonizer is a configuration prober which writes a single header file,
"charmony.h", describing the build environment and facilitating
cross-platform development.  It's similar to Autoconf or Metaconfig, but
written in pure C.

The ".cfh" files within the Lucy core are Clownfish header files.
Clownfish is a purpose-built, declaration-only language which superimposes
a single-inheritance object model on top of C which is specifically
designed to co-exist happily with variety of "host" languages and to allow
limited run-time dynamic subclassing.  For more information see the
Clownfish docs, but if there's one thing you should know about Clownfish OO
before you start hacking, it's that method calls are differentiated from
functions by capitalization:

    Indexer_Add_Doc   <-- Method, typically uses dynamic dispatch.
    Indexer_add_doc   <-- Function, always a direct invocation.

The C files within the Lucy core are where most of Lucy's low-level
functionality lies.  They implement the interface defined by the Clownfish
header files.

The C core is intentionally left incomplete, however; to be usable, it must
be bound to a "host" language.  (In this context, even C is considered a
"host" which must implement the missing pieces and be "bound" to the core.)
Some of the binding code is autogenerated by Clownfish on a spec customized
for each language.  Other pieces are hand-coded in either C (using the
host's C API) or the host language itself.

