# Generated by default/object.tt
package Paws::ACMPCA::CsrExtensions;
  use Moose;
  has KeyUsage => (is => 'ro', isa => 'Paws::ACMPCA::KeyUsage');
  has SubjectInformationAccess => (is => 'ro', isa => 'ArrayRef[Paws::ACMPCA::AccessDescription]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ACMPCA::CsrExtensions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ACMPCA::CsrExtensions object:

  $service_obj->Method(Att1 => { KeyUsage => $value, ..., SubjectInformationAccess => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ACMPCA::CsrExtensions object:

  $result = $service_obj->Method(...);
  $result->Att1->KeyUsage

=head1 DESCRIPTION

Describes the certificate extensions to be added to the certificate
signing request (CSR).

=head1 ATTRIBUTES


=head2 KeyUsage => L<Paws::ACMPCA::KeyUsage>

Indicates the purpose of the certificate and of the key contained in
the certificate.


=head2 SubjectInformationAccess => ArrayRef[L<Paws::ACMPCA::AccessDescription>]

For CA certificates, provides a path to additional information
pertaining to the CA, such as revocation and policy. For more
information, see Subject Information Access
(https://tools.ietf.org/html/rfc5280#section-4.2.2.2) in RFC 5280.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ACMPCA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

