use strict;
use ExtUtils::MakeMaker 6.17;

my $EUMM = eval( $ExtUtils::MakeMaker::VERSION );

my $meta = {
  "abstract"       => "collection of modules for rapid app development",
  "author"         => ["Toby Inkster (TOBYINK) <tobyink\@cpan.org>"],
  "dynamic_config" => 1,
  "generated_by"   => "Dist::Inkt::Profile::TOBYINK version 0.024, CPAN::Meta::Converter version 2.150010",
  "keywords"       => [],
  "license"        => ["perl_5"],
  "meta-spec"      => {
                        url => "http://search.cpan.org/perldoc?CPAN::Meta::Spec",
                        version => 2,
                      },
  "name"           => "Z",
  "no_index"       => { directory => ["eg", "examples", "inc", "t", "xt"] },
  "prereqs"        => {
                        configure => { requires => { "ExtUtils::MakeMaker" => 6.17 } },
                        develop   => { recommends => { "Dist::Inkt" => 0.001 } },
                        runtime   => {
                                       recommends => {
                                                       "indirect" => 0,
                                                       "JSON::MaybeXS" => 0,
                                                       "perl" => "5.014000",
                                                       "PerlX::Maybe::XS" => 0,
                                                       "Type::Tiny::XS" => 0.021,
                                                     },
                                       requires   => {
                                                       "Import::Into"           => 0,
                                                       "List::Util"             => 1.54,
                                                       "match::simple"          => "0.010",
                                                       "Module::Runtime"        => 0,
                                                       "namespace::autoclean"   => 0,
                                                       "Object::Adhoc"          => 0.004,
                                                       "Path::Tiny"             => 0.101,
                                                       "perl"                   => 5.008008,
                                                       "Syntax::Keyword::Try"   => 0.018,
                                                       "Try::Tiny"              => "0.30",
                                                       "Type::Tie"              => 0,
                                                       "Types::Common::Numeric" => 0,
                                                       "Types::Common::String"  => 0,
                                                       "Types::Path::Tiny"      => 0,
                                                       "Types::Standard"        => "1.010000",
                                                       "Zydeco::Lite"           => 0.073,
                                                     },
                                     },
                        test      => { requires => { "Test::More" => 0.96 } },
                      },
  "provides"       => { Z => { file => "lib/Z.pm", version => 0.008 } },
  "release_status" => "stable",
  "resources"      => {
                        bugtracker   => { web => "http://rt.cpan.org/Dist/Display.html?Queue=Z" },
                        homepage     => "https://metacpan.org/release/Z",
                        license      => ["http://dev.perl.org/licenses/"],
                        repository   => {
                                          type => "git",
                                          url  => "git://github.com/tobyink/p5-z.git",
                                          web  => "https://github.com/tobyink/p5-z",
                                        },
                        x_identifier => "http://purl.org/NET/cpan-uri/dist/Z/project",
                      },
  "version"        => 0.008,
};

my %dynamic_config;
do {
if ( $] lt '5.014' ) {
	delete $meta->{prereqs}{runtime}{requires}{'Syntax::Keyword::Try'};
}

if ( $] lt '5.010' ) {
	$meta->{prereqs}{runtime}{requires}{'UNIVERSAL::DOES'} = '0.001';
	$meta->{prereqs}{runtime}{requires}{'Perl6::Say'}      = '0.06';
}

if ( ! eval 'use JSON::MaybeXS 1.003000 ();' ) {
	$meta->{prereqs}{runtime}{requires}{'JSON::PP'} = '2.0';
}

};

my %WriteMakefileArgs = (
	ABSTRACT   => $meta->{abstract},
	AUTHOR     => ($EUMM >= 6.5702 ? $meta->{author} : $meta->{author}[0]),
	DISTNAME   => $meta->{name},
	VERSION    => $meta->{version},
	EXE_FILES  => [ map $_->{file}, values %{ $meta->{x_provides_scripts} || {} } ],
	NAME       => do { my $n = $meta->{name}; $n =~ s/-/::/g; $n },
	test       => { TESTS => "t/*.t" },
	%dynamic_config,
);

$WriteMakefileArgs{LICENSE} = $meta->{license}[0] if $EUMM >= 6.3001;

sub deps
{
	my %r;
	for my $stage (@_)
	{
		for my $dep (keys %{$meta->{prereqs}{$stage}{requires}})
		{
			next if $dep eq 'perl';
			my $ver = $meta->{prereqs}{$stage}{requires}{$dep};
			$r{$dep} = $ver if !exists($r{$dep}) || $ver >= $r{$dep};
		}
	}
	\%r;
}

my ($build_requires, $configure_requires, $runtime_requires, $test_requires);
if ($EUMM >= 6.6303)
{
	$WriteMakefileArgs{BUILD_REQUIRES}     ||= deps('build');
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{TEST_REQUIRES}      ||= deps('test');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime');
}
elsif ($EUMM >= 6.5503)
{
	$WriteMakefileArgs{BUILD_REQUIRES}     ||= deps('build', 'test');
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime');	
}
elsif ($EUMM >= 6.52)
{
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime', 'build', 'test');	
}
else
{
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('configure', 'build', 'test', 'runtime');	
}

{
	my ($minperl) = reverse sort(
		grep defined && /^[0-9]+(\.[0-9]+)?$/,
		map $meta->{prereqs}{$_}{requires}{perl},
		qw( configure build runtime )
	);
	
	if (defined($minperl))
	{
		die "Installing $meta->{name} requires Perl >= $minperl"
			unless $] >= $minperl;
		
		$WriteMakefileArgs{MIN_PERL_VERSION} ||= $minperl
			if $EUMM >= 6.48;
	}
}


my $mm = WriteMakefile(%WriteMakefileArgs);

exit(0);

