/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import ucar.httpservices.HTTPAuthScope;
import ucar.httpservices.HTTPAuthStore;

public class HTTPCachingProvider
implements CredentialsProvider {
    static final int MAX_RETRIES = 3;
    static final String PRINCIPAL = "ucar.nc2.principal";
    static final String URI = "ucar.nc2.url";
    static final String CREDENTIALSPROVIDER = "ucar.nc2.credentialsprovider";
    static final String KEYSTOREPATH = "ucar.nc2.keystore";
    static final String KEYSTOREPASSWORD = "ucar.nc2.keystorepassword";
    static final String TRUSTSTOREPATH = "ucar.nc2.truststore";
    static final String TRUSTSTOREPASSWORD = "ucar.nc2.truststorepassword";
    static final String CREDENTIALS = "ucar.nc2.credentials";
    static final String AUTHSTRING = "ucar.nc2.authstring";
    static String SCHEME = "ucar.nc2.scheme";
    static String PASSWORD = "ucar.nc2.password";
    static String USER = "ucar.nc2.user";
    public static final String WWW_AUTH_RESP = "Authorization";
    public static final String PROXY_AUTH_RESP = "Proxy-Authorization";
    public static boolean TESTING = false;
    protected HTTPAuthStore store = null;
    protected AuthScope authscope = null;
    protected String principal = null;
    protected static List<Triple> cache = new ArrayList<Triple>();
    protected static List<Triple> testlist = null;

    public HTTPCachingProvider(HTTPAuthStore store, AuthScope authscope, String principal) {
        this.store = store;
        this.authscope = authscope;
        this.principal = principal;
    }

    @Override
    public Credentials getCredentials(AuthScope scope) {
        String scheme;
        Credentials credentials;
        if (TESTING) {
            System.err.println("HTTPCachingProvider.getCredentials,arg " + scope.toString());
            System.err.println("HTTPCachingProvider.getCredentials,intern " + this.authscope.toString());
            System.err.flush();
        }
        if ((credentials = HTTPCachingProvider.checkCache(this.principal, this.authscope)) != null) {
            if (TESTING) {
                System.err.println("Using cached credentials: " + credentials);
            }
            return credentials;
        }
        if (TESTING) {
            System.err.println("Credentials not cached");
        }
        if ((scheme = scope.getScheme()) == null) {
            throw new IllegalStateException("HTTPCachingProvider: unsupported scheme: " + scope.getScheme());
        }
        List<HTTPAuthStore.Entry> matches = this.store.search(this.principal, this.authscope);
        if (matches.size() == 0) {
            throw new IllegalStateException("HTTPCachingProvider: no match for:" + this.authscope);
        }
        HTTPAuthStore.Entry entry = matches.get(0);
        CredentialsProvider provider = entry.provider;
        if (provider == null) {
            throw new IllegalStateException("HTTPCachingProvider: no credentials provider provided");
        }
        credentials = provider.getCredentials(scope);
        if (credentials == null) {
            throw new IllegalStateException("HTTPCachingProvider: cannot obtain credentials");
        }
        HTTPCachingProvider.cacheCredentials(entry.principal, this.authscope, credentials);
        if (TESTING) {
            System.err.println("Caching credentials: " + credentials);
        }
        return credentials;
    }

    @Override
    public void setCredentials(AuthScope scope, Credentials creds) {
        HTTPCachingProvider.cacheCredentials(HTTPAuthStore.ANY_PRINCIPAL, this.authscope, creds);
    }

    @Override
    public void clear() {
    }

    public String toString() {
        return "HTTPCachingProvider(" + this.authscope + ")";
    }

    protected static synchronized Credentials cacheCredentials(String principal, AuthScope scope, Credentials creds) {
        Triple p = null;
        Credentials old = null;
        for (Triple t : cache) {
            if (!t.scope.equals(scope)) continue;
            p = t;
            break;
        }
        if (p != null) {
            old = p.creds;
            p.creds = creds;
        } else {
            p = new Triple(principal, scope, creds);
            cache.add(p);
        }
        return old;
    }

    protected static synchronized Credentials checkCache(String principal, AuthScope scope) {
        Credentials creds = null;
        for (Triple p : cache) {
            if (!HTTPAuthScope.identical(p.scope, scope)) continue;
            creds = p.creds;
            break;
        }
        return creds;
    }

    public static synchronized void invalidate(AuthScope scope) {
        if (TESTING && testlist == null) {
            testlist = new ArrayList<Triple>();
        }
        for (int i = cache.size() - 1; i >= 0; --i) {
            Triple p = cache.get(i);
            if (!HTTPAuthScope.equivalent(scope, p.scope)) continue;
            if (TESTING) {
                System.err.println("invalidating: " + p);
                if (testlist == null) {
                    testlist = new ArrayList<Triple>();
                }
                testlist.add(p);
            }
            cache.remove(i);
        }
    }

    public static synchronized void clearCache() {
        cache.clear();
    }

    public static synchronized List<Triple> getCache() {
        ArrayList<Triple> localcache = new ArrayList<Triple>();
        for (Triple p : cache) {
            Triple newp = new Triple(p.principal, p.scope, p.creds);
            localcache.add(newp);
        }
        return localcache;
    }

    public static synchronized List<Triple> getTestList() {
        ArrayList<Triple> list = new ArrayList<Triple>();
        list.addAll(testlist);
        if (testlist != null) {
            testlist.clear();
        }
        return list;
    }

    public static class Triple {
        public String principal;
        public AuthScope scope;
        public Credentials creds;

        public Triple(String principal, AuthScope scope, Credentials creds) {
            this.principal = principal;
            this.scope = scope;
            this.creds = creds;
        }

        public String toString() {
            return "(" + this.principal + "," + this.scope.toString() + "," + this.creds.toString() + ")";
        }
    }
}

