#!/usr/bin/env perl
use strict;
use warnings;
use Math::Prime::Util qw/prime_count prime_count_approx prime_count_lower prime_count_upper LogarithmicIntegral RiemannR/;
use Math::Prime::Util::PP;
use Math::BigInt try=>"GMP,Pari";
use Math::BigFloat;
$| = 1;  # fast pipes


my %pivals = (
    1 => 1,
    2 => 2,
    3 => 4,
    4 => 6,
    5 => 11,
    6 => 18,
    7 => 31,
    8 => 54,
    9 => 97,
    10 => 172,
    11 => 309,
    12 => 564,
    13 => 1028,
    14 => 1900,
    15 => 3512,
    16 => 6542,
    17 => 12251,
    18 => 23000,
    19 => 43390,
    20 => 82025,
    21 => 155611,
    22 => 295947,
    23 => 564163,
    24 => 1077871,
    25 => 2063689,
    26 => 3957809,
    27 => 7603553,
    28 => 14630843,
    29 => 28192750,
    30 => 54400028,
    31 => 105097565,
    32 => 203280221,
    33 => 393615806,
    34 => 762939111,
    35 => 1480206279,
    36 => 2874398515,
    37 => 5586502348,
    38 => 10866266172,
    39 => 21151907950,
    40 => 41203088796,
    41 => 80316571436,
    42 => 156661034233,
    43 => 305761713237,
    44 => 597116381732,
    45 => 1166746786182,
    46 => 2280998753949,
    47 => 4461632979717,
    48 => 8731188863470,
    49 => 17094432576778,
    50 => 33483379603407,
    51 => 65612899915304,
    52 => 128625503610475,
    53 => 252252704148404,
    54 => 494890204904784,
    55 => 971269945245201,
    56 => 1906879381028850,
    57 => 3745011184713964,
    58 => 7357400267843990,
    59 => 14458792895301660,
    60 => 28423094496953330,
    61 => 55890484045084135,
    62 => 109932807585469973,
    63 => 216289611853439384,
    64 => 425656284035217743,
    65 => 837903145466607212,
    66 => 1649819700464785589,
    67 => 3249254387052557215,
    68 => 6400771597544937806,
    69 => 12611864618760352880,
    70 => 24855455363362685793,
    71 => 48995571600129458363,
    72 => 96601075195075186855,
    73 => 190499823401327905601,
    74 => 375744164937699609596,
    75 => 741263521140740113483,
    76 => 1462626667154509638735,
    77 => 2886507381056867953916,
    78 => 5697549648954257752872,
    79 => 11248065615133675809379,
    80 => 22209558889635384205844,
    81 => 43860397052947409356492,
    82 => 86631124695994360074872,
    83 => 171136408646923240987028,
    84 => 338124238545210097236684,
    85 => 668150111666935905701562,
    86 => 1320486952377516565496055,
);

print "\n";
print "Lower / Upper bounds.  Percentages.\n";
print "\n";

printf("  N    %12s  %12s  %12s  %12s\n", "lower", "upper", "PP lower", "PP upper");
printf("-----  %12s  %12s  %12s  %12s\n", '-'x12,'-'x12,'-'x12,'-'x12);
foreach my $e (sort {$a<=>$b} keys %pivals) {
  my $n = Math::BigInt->new(2)**$e;
  my ($pin, $pcl, $pcu, $ppl, $ppu) =
    map { Math::BigFloat->new($_) }
    ($pivals{$e}, prime_count_lower($n), prime_count_upper($n),
    Math::Prime::Util::PP::prime_count_lower($n),
    Math::Prime::Util::PP::prime_count_upper($n),
    );

  #printf "10^%2d  %12d  %12d\n", length($n)-1, $pin-$pcl, $pcu-$pin;
  printf "2^%2d  %12.8f  %12.8f  %12.8f  %12.8f\n",
         $e, 100*($pin-$pcl)/$pin, 100*($pcu-$pin)/$pin,
             100*($pin-$ppl)/$pin, 100*($ppu-$pin)/$pin;
}
