/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.uima.UIMAFramework;
import org.apache.uima.internal.util.I18nUtil;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.apache.uima.pear.tools.InstallationDescriptorHandler;
import org.apache.uima.pear.tools.PackageCreatorException;
import org.apache.uima.util.Level;

public class PackageCreator {
    private static final String PEAR_MESSAGE_RESOURCE_BUNDLE = "org.apache.uima.pear.pear_messages";

    public static void generatePearPackage(String componentID, String mainComponentDesc, String classpath, String datapath, String mainComponentDir, String targetDir, Properties envVars) throws PackageCreatorException {
        PackageCreator.createInstallDescriptor(componentID, mainComponentDesc, classpath, datapath, mainComponentDir, envVars);
        PackageCreator.createPearPackage(componentID, mainComponentDir, targetDir);
    }

    public static String createInstallDescriptor(String componentID, String mainComponentDesc, String classpath, String datapath, String mainComponentDir, Properties envVars) throws PackageCreatorException {
        String commentMessage;
        InstallationDescriptor.ActionInfo actionInfo;
        String installationDesc = null;
        InstallationDescriptor insd = new InstallationDescriptor();
        insd.setMainComponent(componentID);
        insd.setMainComponentDesc(PackageCreator.addMacro(mainComponentDesc));
        insd.clearOSSpecs();
        insd.addOSSpec("NAME", System.getProperty("os.name"));
        insd.clearToolkitsSpecs();
        insd.addToolkitsSpec("JDK_VERSION", System.getProperty("java.version"));
        if (classpath != null) {
            if (classpath.indexOf(":") != -1) {
                UIMAFramework.getLogger(PackageCreator.class).logrb(Level.WARNING, "PackageCreator", "createInstallDescriptor", PEAR_MESSAGE_RESOURCE_BUNDLE, "package_creator_classpath_not_valid_warning");
            }
            actionInfo = new InstallationDescriptor.ActionInfo("set_env_variable");
            actionInfo.params.put("VAR_NAME", "classpath");
            actionInfo.params.put("VAR_VALUE", classpath);
            commentMessage = I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "package_creator_env_setting", new Object[]{"classpath"});
            actionInfo.params.put("COMMENTS", commentMessage);
            insd.addInstallationAction(actionInfo);
        }
        if (datapath != null) {
            if (datapath.indexOf(":") != -1) {
                UIMAFramework.getLogger(PackageCreator.class).logrb(Level.WARNING, "PackageCreator", "createInstallDescriptor", PEAR_MESSAGE_RESOURCE_BUNDLE, "package_creator_datapath_not_valid_warning");
            }
            actionInfo = new InstallationDescriptor.ActionInfo("set_env_variable");
            actionInfo.params.put("VAR_NAME", "uima.datapath");
            actionInfo.params.put("VAR_VALUE", datapath);
            commentMessage = I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "package_creator_env_setting", new Object[]{"uima.datapath"});
            actionInfo.params.put("COMMENTS", commentMessage);
            insd.addInstallationAction(actionInfo);
        }
        if (envVars != null) {
            Enumeration<Object> keys = envVars.keys();
            while (keys.hasMoreElements()) {
                InstallationDescriptor.ActionInfo actionInfo2 = new InstallationDescriptor.ActionInfo("set_env_variable");
                String key = (String)keys.nextElement();
                actionInfo2.params.put("VAR_NAME", key);
                actionInfo2.params.put("VAR_VALUE", envVars.getProperty(key));
                String commentMessage2 = I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "package_creator_env_setting", new Object[]{key});
                actionInfo2.params.put("COMMENTS", commentMessage2);
                insd.addInstallationAction(actionInfo2);
            }
        }
        try {
            File metaDataDir = new File(mainComponentDir, "metadata");
            if (!metaDataDir.exists()) {
                metaDataDir.mkdir();
            }
            File installDesc = new File(mainComponentDir, "metadata/install.xml");
            InstallationDescriptorHandler.saveInstallationDescriptor(insd, installDesc);
            UIMAFramework.getLogger(PackageCreator.class).logrb(Level.INFO, "PackageCreator", "createInstallDescriptor", PEAR_MESSAGE_RESOURCE_BUNDLE, "package_creator_install_desc_created_info", new Object[]{installDesc});
            installationDesc = installDesc.getAbsolutePath();
        }
        catch (IOException ex) {
            throw new PackageCreatorException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_package_creator_creating_pear_package", new Object[]{componentID}, ex);
        }
        return installationDesc;
    }

    public static String createPearPackage(String componentID, String mainComponentDir, String targetDir) throws PackageCreatorException {
        File pearFile;
        try {
            pearFile = new File(targetDir, componentID + ".pear");
            ZipOutputStream zipFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(pearFile)));
            File mainDir = new File(mainComponentDir);
            PackageCreator.zipDirectory(componentID, mainDir.getAbsolutePath(), mainDir, zipFile);
            zipFile.close();
            UIMAFramework.getLogger(PackageCreator.class).logrb(Level.INFO, "PackageCreator", "createInstallDescriptor", PEAR_MESSAGE_RESOURCE_BUNDLE, "package_creator_pear_created_info", new Object[]{pearFile});
        }
        catch (FileNotFoundException ex) {
            throw new PackageCreatorException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_package_creator_creating_pear_package", new Object[]{componentID}, ex);
        }
        catch (IOException ex) {
            throw new PackageCreatorException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_package_creator_creating_pear_package", new Object[]{componentID}, ex);
        }
        return pearFile.getAbsolutePath();
    }

    private static String addMacro(String s) {
        String macro = "$main_root";
        if (s == null || s.length() == 0) {
            return "";
        }
        s = s.startsWith("/") || s.startsWith("\\") ? macro + s : macro + File.separator + s;
        return s;
    }

    private static String getRelativePath(String mainDir, File currentPath) {
        int prefixLength = mainDir.length();
        return currentPath.getAbsolutePath().substring(prefixLength + 1);
    }

    private static void zipDirectory(String componentID, String mainDir, File sourceDir, ZipOutputStream zipOut) throws PackageCreatorException {
        if (!sourceDir.isDirectory()) {
            throw new PackageCreatorException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_package_creator_invalid_directory", new Object[]{sourceDir.getAbsolutePath()});
        }
        try {
            String[] fileList = sourceDir.list();
            byte[] buffer = new byte[5120];
            File current = null;
            ZipEntry currentEntry = null;
            BufferedInputStream bufIn = null;
            for (int i = 0; i < fileList.length; ++i) {
                current = new File(sourceDir, fileList[i]);
                if (current.isDirectory()) {
                    PackageCreator.zipDirectory(componentID, mainDir, current, zipOut);
                    continue;
                }
                String path = PackageCreator.getRelativePath(mainDir, current);
                path = path.replaceAll("\\\\", "/");
                currentEntry = new ZipEntry(path);
                zipOut.putNextEntry(currentEntry);
                bufIn = new BufferedInputStream(new FileInputStream(current));
                int bytesRead = -1;
                while ((bytesRead = bufIn.read(buffer)) != -1) {
                    zipOut.write(buffer, 0, bytesRead);
                }
                bufIn.close();
                zipOut.closeEntry();
            }
        }
        catch (IOException ex) {
            throw new PackageCreatorException(PEAR_MESSAGE_RESOURCE_BUNDLE, "error_package_creator_creating_pear_package", new Object[]{componentID}, ex);
        }
    }
}

