/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;

abstract class ConformalProjection
extends NormalizedProjection {
    private static final long serialVersionUID = 458860570536642265L;
    static final boolean ALLOW_TRIGONOMETRIC_IDENTITIES = true;
    static final double ECCENTRICITY_THRESHOLD = 0.16;
    private transient boolean useIterations;
    transient double ci2;
    transient double ci4;
    transient double ci6;
    transient double ci8;

    ConformalProjection(Initializer initializer) {
        super(initializer);
    }

    void computeCoefficients() {
        this.useIterations = this.eccentricity >= 0.16;
        double d = this.eccentricitySquared;
        double d2 = d * d;
        double d3 = d * d2;
        double d4 = d2 * d2;
        this.ci2 = 0.03611111111111111 * d4 + 0.08333333333333333 * d3 + 0.20833333333333334 * d2 + d / 2.0;
        this.ci4 = 0.07039930555555556 * d4 + 0.12083333333333333 * d3 + 0.14583333333333334 * d2;
        this.ci6 = 0.07232142857142858 * d4 + 0.058333333333333334 * d3;
        this.ci8 = 0.026531498015873015 * d4;
        this.ci4 *= 2.0;
        this.ci6 *= 4.0;
        this.ci8 *= 8.0;
    }

    ConformalProjection(ConformalProjection conformalProjection) {
        super(conformalProjection);
        this.useIterations = conformalProjection.useIterations;
        this.ci2 = conformalProjection.ci2;
        this.ci4 = conformalProjection.ci4;
        this.ci6 = conformalProjection.ci6;
        this.ci8 = conformalProjection.ci8;
    }

    final double \u03c6(double d) throws ProjectionException {
        double d2 = 1.5707963267948966 - 2.0 * Math.atan(d);
        double d3 = Math.sin(2.0 * d2);
        double d4 = d3 * d3;
        d2 += ((this.ci4 + this.ci8 * (0.5 - d4)) * Math.cos(2.0 * d2) + (this.ci2 + this.ci6 * (0.75 - d4))) * d3;
        if (!this.useIterations) {
            return d2;
        }
        d3 = 0.5 * this.eccentricity;
        for (int i = 0; i < 15; ++i) {
            double d5 = this.eccentricity * Math.sin(d2);
            double d6 = d2 - (d2 = 1.5707963267948966 - 2.0 * Math.atan(d * Math.pow((1.0 - d5) / (1.0 + d5), d3)));
            if (Math.abs(d6) > 3.926676682852614E-10) continue;
            return d2;
        }
        throw new ProjectionException(Resources.format((short)46));
    }

    final double expOfNorthing(double d, double d2) {
        return Math.tan(0.7853981633974483 + 0.5 * d) * Math.pow((1.0 - d2) / (1.0 + d2), 0.5 * this.eccentricity);
    }

    final double dy_d\u03c6(double d, double d2) {
        return 1.0 / d2 - this.eccentricitySquared * d2 / (1.0 - this.eccentricitySquared * (d * d));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.computeCoefficients();
    }

    static boolean identityEquals(double d, double d2) {
        return !(Math.abs(d - d2) > 1.5706706731410455E-12 * Math.max(1.0, Math.abs(d2)));
    }
}

