/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.PropertyView;
import org.opengis.util.GenericName;

class AttributeView<V>
extends AbstractAttribute<V> {
    private static final long serialVersionUID = 3617999929561826634L;
    final AbstractFeature feature;
    final String name;

    private AttributeView(AbstractFeature abstractFeature, DefaultAttributeType<V> defaultAttributeType) {
        super(defaultAttributeType);
        this.feature = abstractFeature;
        this.name = defaultAttributeType.getName().toString();
    }

    static <V> AbstractAttribute<V> create(AbstractFeature abstractFeature, DefaultAttributeType<V> defaultAttributeType) {
        if (AttributeView.isSingleton(defaultAttributeType.getMaximumOccurs())) {
            return new Singleton<V>(abstractFeature, defaultAttributeType);
        }
        return new AttributeView<V>(abstractFeature, defaultAttributeType);
    }

    @Override
    public final GenericName getName() {
        return this.type.getName();
    }

    @Override
    public V getValue() {
        return this.type.getValueClass().cast(PropertyView.getValue(this.feature, this.name));
    }

    @Override
    public void setValue(V v) {
        PropertyView.setValue(this.feature, this.name, v);
    }

    @Override
    public Collection<V> getValues() {
        return PropertyView.getValues(this.feature, this.name, this.type.getValueClass());
    }

    @Override
    public final void setValues(Collection<? extends V> collection) {
        PropertyView.setValues(this.feature, this.name, collection);
    }

    @Override
    public final Map<String, AbstractAttribute<?>> characteristics() {
        return Collections.emptyMap();
    }

    public final int hashCode() {
        return PropertyView.hashCode(this.feature, this.name);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            AttributeView attributeView = (AttributeView)object;
            return this.feature == attributeView.feature && Objects.equals(this.name, attributeView.name);
        }
        return false;
    }

    @Override
    public final String toString() {
        return PropertyView.toString(this.getClass(), this.type.getValueClass(), this.getName(), this.getValues());
    }

    private static final class Singleton<V>
    extends AttributeView<V> {
        private static final long serialVersionUID = -808239726590009163L;

        Singleton(AbstractFeature abstractFeature, DefaultAttributeType<V> defaultAttributeType) {
            super(abstractFeature, defaultAttributeType);
        }

        @Override
        public V getValue() {
            return this.type.getValueClass().cast(this.feature.getPropertyValue(this.name));
        }

        @Override
        public void setValue(V v) {
            this.feature.setPropertyValue(this.name, v);
        }

        @Override
        public Collection<V> getValues() {
            return PropertyView.singletonOrEmpty(this.getValue());
        }
    }
}

