/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.TimeZone;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.dom.field.MailboxField;
import org.apache.james.mime4j.dom.field.MailboxListField;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.dom.field.UnstructuredField;
import org.apache.james.mime4j.message.AbstractEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessage
extends AbstractEntity
implements Message {
    @Override
    public String getMessageId() {
        Object field = this.obtainField("Message-ID");
        if (field == null) {
            return null;
        }
        return field.getBody();
    }

    @Override
    public void createMessageId(String hostname) {
        Header header = this.obtainHeader();
        header.setField(this.newMessageId(hostname));
    }

    protected abstract ParsedField newMessageId(String var1);

    @Override
    public String getSubject() {
        UnstructuredField field = (UnstructuredField)this.obtainField("Subject");
        if (field == null) {
            return null;
        }
        return field.getValue();
    }

    @Override
    public void setSubject(String subject) {
        Header header = this.obtainHeader();
        if (subject == null) {
            header.removeFields("Subject");
        } else {
            header.setField(this.newSubject(subject));
        }
    }

    @Override
    public Date getDate() {
        DateTimeField dateField = (DateTimeField)this.obtainField("Date");
        if (dateField == null) {
            return null;
        }
        return dateField.getDate();
    }

    @Override
    public void setDate(Date date) {
        this.setDate(date, null);
    }

    @Override
    public void setDate(Date date, TimeZone zone) {
        Header header = this.obtainHeader();
        if (date == null) {
            header.removeFields("Date");
        } else {
            header.setField(this.newDate(date, zone));
        }
    }

    @Override
    public Mailbox getSender() {
        return this.getMailbox("Sender");
    }

    @Override
    public void setSender(Mailbox sender) {
        this.setMailbox("Sender", sender);
    }

    @Override
    public MailboxList getFrom() {
        return this.getMailboxList("From");
    }

    @Override
    public void setFrom(Mailbox from) {
        this.setMailboxList("From", from);
    }

    @Override
    public void setFrom(Mailbox ... from) {
        this.setMailboxList("From", from);
    }

    @Override
    public void setFrom(Collection<Mailbox> from) {
        this.setMailboxList("From", from);
    }

    @Override
    public AddressList getTo() {
        return this.getAddressList("To");
    }

    @Override
    public void setTo(Address to) {
        this.setAddressList("To", to);
    }

    @Override
    public void setTo(Address ... to) {
        this.setAddressList("To", to);
    }

    @Override
    public void setTo(Collection<? extends Address> to) {
        this.setAddressList("To", to);
    }

    @Override
    public AddressList getCc() {
        return this.getAddressList("Cc");
    }

    @Override
    public void setCc(Address cc) {
        this.setAddressList("Cc", cc);
    }

    @Override
    public void setCc(Address ... cc) {
        this.setAddressList("Cc", cc);
    }

    @Override
    public void setCc(Collection<? extends Address> cc) {
        this.setAddressList("Cc", cc);
    }

    @Override
    public AddressList getBcc() {
        return this.getAddressList("Bcc");
    }

    @Override
    public void setBcc(Address bcc) {
        this.setAddressList("Bcc", bcc);
    }

    @Override
    public void setBcc(Address ... bcc) {
        this.setAddressList("Bcc", bcc);
    }

    @Override
    public void setBcc(Collection<? extends Address> bcc) {
        this.setAddressList("Bcc", bcc);
    }

    @Override
    public AddressList getReplyTo() {
        return this.getAddressList("Reply-To");
    }

    @Override
    public void setReplyTo(Address replyTo) {
        this.setAddressList("Reply-To", replyTo);
    }

    @Override
    public void setReplyTo(Address ... replyTo) {
        this.setAddressList("Reply-To", replyTo);
    }

    @Override
    public void setReplyTo(Collection<? extends Address> replyTo) {
        this.setAddressList("Reply-To", replyTo);
    }

    private Mailbox getMailbox(String fieldName) {
        MailboxField field = (MailboxField)this.obtainField(fieldName);
        if (field == null) {
            return null;
        }
        return field.getMailbox();
    }

    private void setMailbox(String fieldName, Mailbox mailbox) {
        Header header = this.obtainHeader();
        if (mailbox == null) {
            header.removeFields(fieldName);
        } else {
            header.setField(this.newMailbox(fieldName, mailbox));
        }
    }

    private MailboxList getMailboxList(String fieldName) {
        MailboxListField field = (MailboxListField)this.obtainField(fieldName);
        if (field == null) {
            return null;
        }
        return field.getMailboxList();
    }

    private void setMailboxList(String fieldName, Mailbox mailbox) {
        this.setMailboxList(fieldName, mailbox == null ? null : Collections.singleton(mailbox));
    }

    private void setMailboxList(String fieldName, Mailbox ... mailboxes) {
        this.setMailboxList(fieldName, mailboxes == null ? null : Arrays.asList(mailboxes));
    }

    private void setMailboxList(String fieldName, Collection<Mailbox> mailboxes) {
        Header header = this.obtainHeader();
        if (mailboxes == null || mailboxes.isEmpty()) {
            header.removeFields(fieldName);
        } else {
            header.setField(this.newMailboxList(fieldName, mailboxes));
        }
    }

    private AddressList getAddressList(String fieldName) {
        AddressListField field = (AddressListField)this.obtainField(fieldName);
        if (field == null) {
            return null;
        }
        return field.getAddressList();
    }

    private void setAddressList(String fieldName, Address address) {
        this.setAddressList(fieldName, address == null ? null : Collections.singleton(address));
    }

    private void setAddressList(String fieldName, Address ... addresses) {
        this.setAddressList(fieldName, addresses == null ? null : Arrays.asList(addresses));
    }

    private void setAddressList(String fieldName, Collection<? extends Address> addresses) {
        Header header = this.obtainHeader();
        if (addresses == null || addresses.isEmpty()) {
            header.removeFields(fieldName);
        } else {
            header.setField(this.newAddressList(fieldName, addresses));
        }
    }

    protected abstract AddressListField newAddressList(String var1, Collection<? extends Address> var2);

    protected abstract UnstructuredField newSubject(String var1);

    protected abstract DateTimeField newDate(Date var1, TimeZone var2);

    protected abstract MailboxField newMailbox(String var1, Mailbox var2);

    protected abstract MailboxListField newMailboxList(String var1, Collection<Mailbox> var2);
}

