# Generated by default/object.tt
package Paws::Route53Resolver::FirewallRuleGroupAssociation;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has CreatorRequestId => (is => 'ro', isa => 'Str');
  has FirewallRuleGroupId => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str');
  has ManagedOwnerName => (is => 'ro', isa => 'Str');
  has ModificationTime => (is => 'ro', isa => 'Str');
  has MutationProtection => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has Priority => (is => 'ro', isa => 'Int');
  has Status => (is => 'ro', isa => 'Str');
  has StatusMessage => (is => 'ro', isa => 'Str');
  has VpcId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Route53Resolver::FirewallRuleGroupAssociation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Route53Resolver::FirewallRuleGroupAssociation object:

  $service_obj->Method(Att1 => { Arn => $value, ..., VpcId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Route53Resolver::FirewallRuleGroupAssociation object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

An association between a firewall rule group and a VPC, which enables
DNS filtering for the VPC.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the firewall rule group association.


=head2 CreationTime => Str

The date and time that the association was created, in Unix time format
and Coordinated Universal Time (UTC).


=head2 CreatorRequestId => Str

A unique string defined by you to identify the request. This allows you
to retry failed requests without the risk of running the operation
twice. This can be any unique string, for example, a timestamp.


=head2 FirewallRuleGroupId => Str

The unique identifier of the firewall rule group.


=head2 Id => Str

The identifier for the association.


=head2 ManagedOwnerName => Str

The owner of the association, used only for associations that are not
managed by you. If you use AWS Firewall Manager to manage your DNS
Firewalls, then this reports Firewall Manager as the managed owner.


=head2 ModificationTime => Str

The date and time that the association was last modified, in Unix time
format and Coordinated Universal Time (UTC).


=head2 MutationProtection => Str

If enabled, this setting disallows modification or removal of the
association, to help prevent against accidentally altering DNS firewall
protections.


=head2 Name => Str

The name of the association.


=head2 Priority => Int

The setting that determines the processing order of the rule group
among the rule groups that are associated with a single VPC. DNS
Firewall filters VPC traffic starting from rule group with the lowest
numeric priority setting.


=head2 Status => Str

The current status of the association.


=head2 StatusMessage => Str

Additional information about the status of the response, if available.


=head2 VpcId => Str

The unique identifier of the VPC that is associated with the rule
group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Route53Resolver>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

