# Generated by default/object.tt
package Paws::SecurityHub::AwsSecretsManagerSecretDetails;
  use Moose;
  has Deleted => (is => 'ro', isa => 'Bool');
  has Description => (is => 'ro', isa => 'Str');
  has KmsKeyId => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has RotationEnabled => (is => 'ro', isa => 'Bool');
  has RotationLambdaArn => (is => 'ro', isa => 'Str');
  has RotationOccurredWithinFrequency => (is => 'ro', isa => 'Bool');
  has RotationRules => (is => 'ro', isa => 'Paws::SecurityHub::AwsSecretsManagerSecretRotationRules');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsSecretsManagerSecretDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsSecretsManagerSecretDetails object:

  $service_obj->Method(Att1 => { Deleted => $value, ..., RotationRules => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsSecretsManagerSecretDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->Deleted

=head1 DESCRIPTION

Details about an AWS Secrets Manager secret.

=head1 ATTRIBUTES


=head2 Deleted => Bool

Whether the secret is deleted.


=head2 Description => Str

The user-provided description of the secret.


=head2 KmsKeyId => Str

The ARN, Key ID, or alias of the AWS KMS customer master key (CMK) used
to encrypt the C<SecretString> or C<SecretBinary> values for versions
of this secret.


=head2 Name => Str

The name of the secret.


=head2 RotationEnabled => Bool

Whether rotation is enabled.


=head2 RotationLambdaArn => Str

The ARN of the Lambda function that rotates the secret.


=head2 RotationOccurredWithinFrequency => Bool

Whether the rotation occurred within the specified rotation frequency.


=head2 RotationRules => L<Paws::SecurityHub::AwsSecretsManagerSecretRotationRules>

Defines the rotation schedule for the secret.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

