# Generated by default/object.tt
package Paws::SageMaker::LabelingJobDataSource;
  use Moose;
  has S3DataSource => (is => 'ro', isa => 'Paws::SageMaker::LabelingJobS3DataSource');
  has SnsDataSource => (is => 'ro', isa => 'Paws::SageMaker::LabelingJobSnsDataSource');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::LabelingJobDataSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::LabelingJobDataSource object:

  $service_obj->Method(Att1 => { S3DataSource => $value, ..., SnsDataSource => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::LabelingJobDataSource object:

  $result = $service_obj->Method(...);
  $result->Att1->S3DataSource

=head1 DESCRIPTION

Provides information about the location of input data.

You must specify at least one of the following: C<S3DataSource> or
C<SnsDataSource>.

Use C<SnsDataSource> to specify an SNS input topic for a streaming
labeling job. If you do not specify and SNS input topic ARN, Ground
Truth will create a one-time labeling job.

Use C<S3DataSource> to specify an input manifest file for both
streaming and one-time labeling jobs. Adding an C<S3DataSource> is
optional if you use C<SnsDataSource> to create a streaming labeling
job.

=head1 ATTRIBUTES


=head2 S3DataSource => L<Paws::SageMaker::LabelingJobS3DataSource>

The Amazon S3 location of the input data objects.


=head2 SnsDataSource => L<Paws::SageMaker::LabelingJobSnsDataSource>

An Amazon SNS data source used for streaming labeling jobs. To learn
more, see Send Data to a Streaming Labeling Job
(https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-send-data).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

