/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.primitive;

import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.primitive.AbstractDecimalMorpher;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class FloatMorpher
extends AbstractDecimalMorpher {
    private float defaultValue;

    public FloatMorpher() {
    }

    public FloatMorpher(float defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FloatMorpher)) {
            return false;
        }
        FloatMorpher other = (FloatMorpher)obj;
        EqualsBuilder builder = new EqualsBuilder();
        if (this.isUseDefault() && other.isUseDefault()) {
            builder.append(this.getDefaultValue(), other.getDefaultValue());
            return builder.isEquals();
        }
        if (!this.isUseDefault() && !other.isUseDefault()) {
            return builder.isEquals();
        }
        return false;
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        if (this.isUseDefault()) {
            builder.append(this.getDefaultValue());
        }
        return builder.toHashCode();
    }

    public float morph(Object value) {
        if (value == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException("value is null");
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        float i = 0.0f;
        try {
            i = Float.parseFloat(String.valueOf(value));
            return i;
        }
        catch (NumberFormatException nfe) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException(nfe);
        }
    }

    public Class morphsTo() {
        return Float.TYPE;
    }
}

