/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.objectbank;

import edu.stanford.nlp.io.EncodingFileReader;
import edu.stanford.nlp.util.AbstractIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReaderIteratorFactory
implements Iterable<Reader> {
    protected Collection<Object> c = new ArrayList<Object>();
    protected String enc = "UTF-8";

    public ReaderIteratorFactory(Collection<?> c) {
        this();
        this.c.addAll(c);
    }

    public ReaderIteratorFactory(Collection<?> c, String encoding) {
        this();
        this.enc = encoding;
        this.c.addAll(c);
    }

    public ReaderIteratorFactory(Object o) {
        this(Collections.singleton(o));
    }

    public ReaderIteratorFactory(Object o, String encoding) {
        this(Collections.singleton(o), encoding);
    }

    public ReaderIteratorFactory() {
    }

    @Override
    public Iterator<Reader> iterator() {
        return new ReaderIterator();
    }

    public boolean add(Object o) {
        return this.c.add(o);
    }

    public boolean remove(Object o) {
        return this.c.remove(o);
    }

    public boolean addAll(Collection<?> c) {
        return this.c.addAll(c);
    }

    public boolean removeAll(Collection<?> c) {
        return this.c.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.c.retainAll(c);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReaderIterator
    extends AbstractIterator<Reader> {
        private Iterator<?> iter;
        private Reader nextObject;

        public ReaderIterator() {
            this.iter = ReaderIteratorFactory.this.c.iterator();
            this.setNextObject();
        }

        private void setNextObject() {
            block9: {
                if (!this.iter.hasNext()) {
                    this.nextObject = null;
                    this.iter = null;
                    return;
                }
                Object o = this.iter.next();
                try {
                    if (o instanceof File) {
                        File file = (File)o;
                        if (file.isDirectory()) {
                            ArrayList<File> l = new ArrayList<File>();
                            l.addAll(Arrays.asList(file.listFiles()));
                            while (this.iter.hasNext()) {
                                l.add((File)this.iter.next());
                            }
                            this.iter = l.iterator();
                            file = (File)this.iter.next();
                        }
                        this.nextObject = file.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), ReaderIteratorFactory.this.enc)) : new BufferedReader(new EncodingFileReader(file, ReaderIteratorFactory.this.enc));
                        break block9;
                    }
                    if (o instanceof String) {
                        this.nextObject = new BufferedReader(new StringReader((String)o));
                        break block9;
                    }
                    if (o instanceof URL) {
                        this.nextObject = new BufferedReader(new InputStreamReader(((URL)o).openStream()));
                        break block9;
                    }
                    if (o instanceof Reader) {
                        this.nextObject = new BufferedReader((Reader)o);
                        break block9;
                    }
                    throw new RuntimeException("don't know how to get Reader from " + o);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextObject != null;
        }

        @Override
        public Reader next() {
            if (this.nextObject == null) {
                throw new NoSuchElementException();
            }
            Reader tmp = this.nextObject;
            this.setNextObject();
            return tmp;
        }
    }
}

