/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.DependencyFactory;
import edu.stanford.nlp.trees.LabeledConstituent;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedDependency
implements Dependency<Label, Label, Object> {
    private Label regent;
    private Label dependent;
    private Object name;
    private static final long serialVersionUID = 5L;

    public int hashCode() {
        return this.regent.hashCode() ^ this.dependent.hashCode() ^ this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NamedDependency) {
            NamedDependency d = (NamedDependency)o;
            return this.governor().equals(d.governor()) && this.dependent().equals(d.dependent());
        }
        return false;
    }

    @Override
    public boolean equalsIgnoreName(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Dependency) {
            Dependency d = (Dependency)ErasureUtils.uncheckedCast(o);
            return this.governor().equals(d.governor()) && this.dependent().equals(d.dependent());
        }
        return false;
    }

    public String toString() {
        return this.regent + " --" + this.name + "--> " + this.dependent;
    }

    @Override
    public String toString(String format) {
        if ("xml".equals(format)) {
            return "<dep type=\"" + XMLUtils.escapeXML(this.name().toString()) + "\">\n    <governor>" + XMLUtils.escapeXML(this.governor().value()) + "</governor>\n    <dependent>" + XMLUtils.escapeXML(this.dependent().value()) + "</dependent>\n  </dep>";
        }
        if ("predicate".equals(format)) {
            return this.name() + "(" + this.governor() + "," + this.dependent() + ")";
        }
        return this.toString();
    }

    public NamedDependency(String regent, String dependent, Object name) {
        this(new StringLabel(regent), new StringLabel(dependent), name);
    }

    public NamedDependency(String regent, int regentIndex, String dependent, int dependentIndex, Object name) {
        this(regent, regentIndex, regentIndex + 1, dependent, dependentIndex, dependentIndex + 1, name);
    }

    public NamedDependency(String regent, int regentStartIndex, int regentEndIndex, String dependent, int depStartIndex, int depEndIndex, Object name) {
        this(new LabeledConstituent(regentStartIndex, regentEndIndex, regent), new LabeledConstituent(depStartIndex, depEndIndex, dependent), name);
    }

    public NamedDependency(Label regent, Label dependent, Object name) {
        if (regent == null || dependent == null) {
            throw new IllegalArgumentException("governor or dependent cannot be null");
        }
        this.regent = regent;
        this.dependent = dependent;
        this.name = name;
    }

    @Override
    public Label governor() {
        return this.regent;
    }

    @Override
    public Label dependent() {
        return this.dependent;
    }

    @Override
    public Object name() {
        return this.name;
    }

    @Override
    public DependencyFactory dependencyFactory() {
        return DependencyFactoryHolder.df;
    }

    public static DependencyFactory factory() {
        return DependencyFactoryHolder.df;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamedDependencyFactory
    implements DependencyFactory {
        @Override
        public Dependency<Label, Label, Object> newDependency(Label regent, Label dependent) {
            return this.newDependency(regent, dependent, null);
        }

        @Override
        public Dependency<Label, Label, Object> newDependency(Label regent, Label dependent, Object name) {
            return new NamedDependency(regent, dependent, name);
        }
    }

    private static class DependencyFactoryHolder {
        private static final DependencyFactory df = new NamedDependencyFactory();

        private DependencyFactoryHolder() {
        }
    }
}

